/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.netclient;

import com.simba.GlobalParam;
import com.simba.common.frameclient.IClient;
import com.simba.common.frameclient.IClientManager;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.utils.XmlTools;
import com.simba.server.components.SortControllerManager;
import com.simba.server.netclient.ClientNetTask;
import com.simba.server.netclient.DefaultBootstrapManager;
import com.simba.server.netclient.DefaultClientCreator;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public class DefaultClientManager
implements IClientManager {
    protected static final Logger logger = Logger.getLogger(DefaultClientManager.class);
    private final ConcurrentHashMap<String, IClient> currentClients = new ConcurrentHashMap();
    private IClient defacultClient;
    private String defaultClientId;
    private final ClientNetTask netTask = new ClientNetTask();

    public static DefaultClientManager getInstance() {
        return DefaultClientManagerHolder.INSTANCE;
    }

    @Override
    public void addClient(IClient client) {
        this.currentClients.put(client.getId(), client);
    }

    @Override
    public void checkClientStatus() {
        try {
            for (Map.Entry<String, IClient> clientEntry : this.currentClients.entrySet()) {
                IClient curClient = clientEntry.getValue();
                String currentMode = SortControllerManager.getInstance().getCurrentSortInfoMode();
                if (curClient != null && !curClient.isConnected().booleanValue()) {
                    if (!curClient.getId().toLowerCase().contains(currentMode.toLowerCase())) continue;
                    curClient.doReconnected();
                    LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Reconnect Monitor Client: " + curClient.getId(), 3));
                    continue;
                }
                if (curClient.getId().toLowerCase().contains(currentMode.toLowerCase())) continue;
                curClient.disconnect();
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Disconnect Monitor Client: " + curClient.getId(), 3));
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[DefaultClientManager.checkClientStatus] Catch Exception : " + ex.getMessage(), 2));
        }
    }

    @Override
    public IClient getClient(String clientId) {
        Map.Entry<String, IClient> clientEntry;
        IClient curClient = null;
        Iterator<Map.Entry<String, IClient>> iterator = this.currentClients.entrySet().iterator();
        while (iterator.hasNext() && !(curClient = (clientEntry = iterator.next()).getValue()).getId().contains(clientId)) {
        }
        return curClient;
    }

    @Override
    public int getClientCount() {
        return 0;
    }

    @Override
    public IClient[] getClientList() {
        return this.currentClients.values().toArray(new IClient[this.currentClients.size()]);
    }

    public int getClientStatus() {
        int status = 0;
        if (this.defacultClient != null && this.defacultClient.isConnected().booleanValue()) {
            status = 1;
        }
        return status;
    }

    @Override
    public void init(String configFile) {
        try {
            Document rootDoc = XmlTools.getXmlDocFromFile(new File("etc" + GlobalParam.PATH_SEP + configFile));
            Element root = rootDoc.getRootElement();
            this.initClients(root);
            this.startNetTask();
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Clients init error : " + ex.getMessage(), 2));
        }
    }

    @Override
    public IClient removeClient(String clientId) {
        return null;
    }

    public void sendUploadMsgToDefaultClient(byte[] content) {
        try {
            IClient[] clients;
            String currentMode = SortControllerManager.getInstance().getCurrentSortInfoMode();
            for (IClient client : clients = DefaultClientManager.getInstance().getClientList()) {
                String clientName = client.getId().split("-")[0];
                if (!currentMode.equalsIgnoreCase(clientName) || !client.isConnected().booleanValue()) continue;
                client.send(content);
            }
        }
        catch (Exception e) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Clients sendUploadMsgToDefaultClient error : " + e.getMessage(), 2));
        }
    }

    public void sendUploadMsgToStoClient(byte[] content) {
        try {
            IClient[] clients;
            String currentMode = SortControllerManager.getInstance().getCurrentSortInfoMode();
            for (IClient client : clients = DefaultClientManager.getInstance().getClientList()) {
                String clientName = client.getId().split("-")[0];
                if (!currentMode.equalsIgnoreCase(clientName) || !client.isConnected().booleanValue()) continue;
                client.send(content);
            }
        }
        catch (Exception e) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Clients sendUploadMsgToDefaultClient error : " + e.getMessage(), 2));
        }
    }

    private void initClients(Element root) {
        List<Element> clients = root.getChildren();
        for (Element clientElement : clients) {
            if (clientElement == null) continue;
            String name = clientElement.getAttributeValue("name");
            String serverHost = clientElement.getAttributeValue("ip");
            String port = clientElement.getAttributeValue("port");
            int serverPort = Integer.parseInt(port);
            String clientId = name + "-" + serverHost + ":" + port;
            IClient client = DefaultClientCreator.getInstance().createClient(name);
            client.start(clientId, serverHost, serverPort, name, DefaultBootstrapManager.getInstance());
            this.addClient(client);
        }
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[DefaultClientManager.initClients] DefaultClient ID : [" + this.defaultClientId + "]", 3));
    }

    private void startNetTask() {
        this.netTask.start();
    }

    private static class DefaultClientManagerHolder {
        private static final DefaultClientManager INSTANCE = new DefaultClientManager();

        private DefaultClientManagerHolder() {
        }
    }
}

