/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.netclient;

import com.simba.common.frameclient.BaseClient;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.PlatInstance;
import com.simba.server.components.PlatInstanceManager;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.yunda.YundaCPModeManager;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class ClientSto
extends BaseClient {
    private static final Logger logger = Logger.getLogger(ClientSto.class);

    @Override
    public void messageReceived(Channel channel, Object message) {
        try {
            byte[] receiveBuffer = (byte[])message;
            if (receiveBuffer[0] != 2) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Received an error messge [" + receiveBuffer + "]", 3));
                return;
            }
            int contentLen = receiveBuffer.length - 1;
            byte[] content = new byte[contentLen];
            System.arraycopy(receiveBuffer, 1, content, 0, contentLen);
            String sortContent = new String(content, "UTF-8");
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[ClientSto.messageReceived] :[" + sortContent + "]", 3));
            if (sortContent.startsWith("PING")) {
                this.handlePINGMessage(sortContent);
            } else if (sortContent.startsWith("CP")) {
                this.handleCPMessage(sortContent);
            } else if (sortContent.startsWith("ST")) {
                this.handleSTMessage(sortContent);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[ClientSto.messageReceived] Catch an exception : " + ex.getMessage(), 2));
        }
    }

    @Override
    public void onChannelConnected(Channel channel) {
    }

    @Override
    public void send(byte[] content) {
        try {
            if (content == null || content.length == 0) {
                return;
            }
            int allMsgLength = content.length + 4;
            byte[] header = ClientSto.my_int_to_bb_be(content.length);
            byte[] sendBuffer = new byte[allMsgLength];
            System.arraycopy(header, 0, sendBuffer, 0, header.length);
            System.arraycopy(content, 0, sendBuffer, 4, content.length);
            this.connection.send(sendBuffer, false);
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[ClientSto.send]  : " + new String(sendBuffer, "UTF-8"), 3));
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[ClientSto.send] Catch an exception : " + ex.getMessage(), 2));
        }
    }

    public static byte[] my_int_to_bb_le(int myInteger) {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(myInteger).array();
    }

    public static int my_bb_to_int_le(byte[] byteBarray) {
        return ByteBuffer.wrap(byteBarray).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public static byte[] my_int_to_bb_be(int myInteger) {
        return ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(myInteger).array();
    }

    private void handleCPMessage(String sortContent) {
        String[] splitMessage = sortContent.split(":");
        String messageName = splitMessage[0];
        String resPonse = "ACK-" + messageName;
        this.send(resPonse.getBytes());
        String messageBody = splitMessage[1];
        JSONObject dataObj = null;
        try {
            String[] videoMessage = messageBody.split(",");
            String barcode = videoMessage[0];
            SortInfo toCPSortInfo = YundaCPModeManager.getInstance().getSortInfoByBarcode(barcode);
            if (toCPSortInfo == null) {
                SortInfo videoCPFailed = new SortInfo();
                JSONObject cpFailedObj = new JSONObject();
                videoCPFailed.setBarcode(barcode);
                videoCPFailed.setComplementResult("failed");
                dataObj = cpFailedObj;
                videoCPFailed.setDataObj(dataObj);
                toCPSortInfo = videoCPFailed;
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), messageName + barcode + "  sortinfo is null  ", 3));
            } else {
                dataObj = toCPSortInfo.getDataObj();
                toCPSortInfo.setComplementResult("success");
            }
            if (videoMessage.length > 1) {
                String slotsContent = videoMessage[1];
                dataObj.put("slotsContent", slotsContent);
            } else {
                dataObj.put("slotsContent", "0");
            }
            if (videoMessage.length > 2) {
                String cpflag = videoMessage[2];
                dataObj.put("cpFlag", cpflag);
            } else {
                dataObj.put("cpFlag", "none");
            }
            SortControllerManager.getInstance().onComplementMessage(toCPSortInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[Method]:[ClientSto.handleCPMessage] , error:" + ex.getMessage() + "]", 2));
        }
    }

    private void handlePINGMessage(String sortContent) {
        String response = "PONG";
        this.send(response.getBytes());
    }

    private void handleSTMessage(String sortContent) {
        String[] splitMessage = sortContent.split(":");
        String messageName = splitMessage[0];
        String response = "ACK-" + messageName;
        this.send(response.getBytes());
        String messageBody = splitMessage[1];
        try {
            JSONObject requestObj = new JSONObject();
            String[] mesType = messageBody.split(",");
            String slotFlag = mesType[0];
            requestObj.put("slotFlag", slotFlag);
            String barcode = mesType[1];
            requestObj.put("barcode", barcode);
            String platId = mesType[2];
            requestObj.put("platId", platId);
            String slotsContent = mesType[3];
            requestObj.put("slotsContent", slotsContent);
            String recvTime = mesType[4];
            requestObj.put("recvTime", recvTime);
            String logicSlot = "0";
            if (mesType.length >= 6) {
                logicSlot = mesType[5];
            }
            requestObj.put("logicSlot", logicSlot);
            String businessType = "0";
            if (mesType.length >= 7) {
                businessType = mesType[6];
            }
            requestObj.put("businessType", businessType);
            requestObj.put("weight", "0");
            PlatInstance platInstance = PlatInstanceManager.getInstance().getPlatById(platId);
            if (platInstance == null) {
                return;
            }
            platInstance.handleScannedCommand(null, requestObj);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[Method]:[ClientSto.handleSTMessage] , error:" + ex.getMessage() + "]", 2));
        }
    }
}

