/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.jsonservice.serivces;

import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.jsonservice.JsonService;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.SortInfoManager;
import com.simba.server.components.data.SortInfo;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONException;
import org.json.JSONObject;

public class StoBarcodeQueryJsonService
implements JsonService {
    public static final String NAME = "BarcodeQuery";
    private static final Logger logger = Logger.getLogger(StoBarcodeQueryJsonService.class);

    @Override
    public void handleRequest(Channel channel, Object content) {
        try {
            JSONObject request = (JSONObject)content;
            String name = request.getString("ServiceName");
            if (name == null || !name.equals(NAME)) {
                return;
            }
            String barcode = request.getString("barcode");
            if (barcode == null) {
                return;
            }
            SortInfo unDefinedsortInfo = SortInfoManager.getInstance().createSortInfo();
            unDefinedsortInfo.setBarcode(barcode);
            unDefinedsortInfo.getBarcodeList().add(barcode);
            unDefinedsortInfo.setDataObj(request);
            SortControllerManager.getInstance().onBarcodeQueryMessage(unDefinedsortInfo);
            String strRespone = this.createQueryResponse(unDefinedsortInfo);
            JsonChannelManager.getInstance().commitResponse(channel, strRespone.getBytes(), false);
        }
        catch (JSONException ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "barcode query Json Service Error : exception info : ", 2));
        }
    }

    private String createQueryResponse(SortInfo sortInfo) {
        JSONObject sortInfoObj = new JSONObject();
        sortInfoObj.put("ServiceName", "AckBarcodeQuery");
        String slots = "";
        try {
            if (sortInfo.getSlotsList().size() > 0) {
                for (int slot : sortInfo.getSlotsList()) {
                    slots = slots + String.valueOf(slot) + "|";
                }
            }
            if (!slots.equalsIgnoreCase("")) {
                sortInfoObj.put("factualSlot", slots.substring(0, slots.length() - 1));
            } else {
                sortInfoObj.put("factualSlot", "0");
            }
            sortInfoObj.put("errorCode", sortInfo.getDroppedErrorCode());
            sortInfoObj.put("droppedSlot", sortInfo.getDroppedSlotId());
            sortInfoObj.put("sortModel", "sto-" + sortInfo.getSortInfoMode().toString());
            sortInfoObj.put("dataObect", sortInfo.getDataObj());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sortInfoObj.toString();
    }
}

