/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.jsonservice.serivces;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.jsonservice.JsonService;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.SorterCommonParams;
import com.simba.server.controllers.sto.data.STOSlotManager;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class ShiftJsonService
implements JsonService {
    public static final String NAME = "Shift";
    private static final Logger logger = Logger.getLogger(ShiftJsonService.class);

    @Override
    public void handleRequest(Channel channel, Object content) {
        try {
            ICommand command = null;
            Boolean ret = false;
            JSONObject shiftMode = (JSONObject)content;
            String currentMode = shiftMode.getString("CurrentMode");
            SortControllerManager.getInstance().setCurrentSortInfoMode(currentMode);
            STOSlotManager.getInstance().resetStoSortPlan();
            STOSlotManager.getInstance().updateSlotStatus();
            SlotManager.getInstance().init();
            STOSlotManager.getInstance().getMapBindPacket().clear();
            if (currentMode.equalsIgnoreCase("Start")) {
                long shiftID = System.currentTimeMillis();
                String strShiftID = String.valueOf(shiftID);
                command = CommandCreator.getInstance().createCommand("STOShiftUpdate", strShiftID);
                ret = SQLCommandExecutor.getInstance().executeCmd(command);
            }
            SorterCommonParams.getInstance().UpdateSorterStatus();
            JSONObject contentObj = new JSONObject();
            contentObj.put("ServiceName", "AckSetSortStatus");
            contentObj.put("Result", "success");
            String requestContent = contentObj.toString();
            JsonChannelManager.getInstance().commitResponse(channel, requestContent.getBytes(), false);
            command = CommandCreator.getInstance().createCommand("WebQuerySetting", null);
            ret = WebCommandExecutor.getInstance().executeCmd(command);
        }
        catch (Exception e) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[SetSortStatusJsonService.handleRequest] error : " + e.getMessage(), 2));
        }
    }
}

