/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.jsonservice.serivces;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.jsonservice.JsonService;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.SorterCommonParams;
import com.simba.server.components.data.ShiftInfo;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.controllers.sto.STOCommonParams;
import com.simba.server.controllers.sto.data.STOSlotManager;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class SetSortStatusJsonService
implements JsonService {
    public static final String NAME = "SetSortStatus";
    private static final Logger logger = Logger.getLogger(SetSortStatusJsonService.class);

    @Override
    public void handleRequest(Channel channel, Object content) {
        try {
            this.autoSlotPackage();
            JSONObject MachineMode = (JSONObject)content;
            String currentMode = MachineMode.getString("CurrentMode");
            String currentType = MachineMode.getString("CurrentType");
            String currentBanciType = MachineMode.getString("BanciType");
            SortControllerManager.getInstance().setCurrentSortInfoMode(currentMode);
            JSONObject contentObj = new JSONObject();
            ShiftInfo shiftInfo = new ShiftInfo();
            if (currentMode.equalsIgnoreCase("STO")) {
                if (STOCommonParams.getInstance().isUserBanci()) {
                    boolean queryShiftRes = false;
                    long shiftID = 0L;
                    shiftInfo.setResMsg("fail");
                    if (currentBanciType.equalsIgnoreCase("start")) {
                        shiftID = System.currentTimeMillis();
                        shiftInfo.setStatus(1);
                    } else {
                        shiftID = STOCommonParams.getInstance().getCurBanci();
                        shiftInfo.setStatus(0);
                    }
                    shiftInfo.setShiftID(shiftID);
                    if (currentType.equalsIgnoreCase("arrival")) {
                        shiftInfo.setBizType(1);
                    } else {
                        shiftInfo.setBizType(2);
                    }
                    ICommand command = CommandCreator.getInstance().createCommand("WebQuerySetting", shiftInfo);
                    Boolean ret = WebCommandExecutor.getInstance().executeCmd(command);
                    if (ret.booleanValue()) {
                        if (currentBanciType.equalsIgnoreCase("start")) {
                            command = CommandCreator.getInstance().createCommand("STOShiftUpdate", String.valueOf(shiftID));
                            Boolean bl = SQLCommandExecutor.getInstance().executeCmd(command);
                        }
                        STOCommonParams.getInstance().setStoMode(currentType);
                        SortControllerManager.getInstance().setCurrentSortType(currentType);
                        SorterCommonParams.getInstance().UpdateSorterStatus();
                    }
                    String msg = shiftInfo.getResMsg();
                    contentObj.put("errorMsg", msg);
                } else {
                    SortControllerManager.getInstance().setCurrentSortType(currentType);
                    STOCommonParams.getInstance().setStoMode(currentType);
                    LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "SetSortStatusJsonService currentType= : " + currentType, 1));
                    SorterCommonParams.getInstance().UpdateSorterStatus();
                }
            } else {
                SortControllerManager.getInstance().setCurrentSortType(currentType);
                STOCommonParams.getInstance().setStoMode(currentType);
                SorterCommonParams.getInstance().UpdateSorterStatus();
            }
            contentObj.put("ServiceName", "AckSetSortStatus");
            if (shiftInfo.getResMsg() != null && shiftInfo.getResMsg().length() > 1) {
                contentObj.put("Result", "fail");
            } else {
                contentObj.put("Result", "success");
            }
            String requestContent = contentObj.toString();
            JsonChannelManager.getInstance().commitResponse(channel, requestContent.getBytes(), false);
            if (shiftInfo.getResMsg() != null && shiftInfo.getResMsg().length() > 1) {
                STOSlotManager.getInstance().updateSlotStatus();
                SlotManager.getInstance().init();
                STOSlotManager.getInstance().getMapBindPacket().clear();
            }
        }
        catch (Exception e) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[SetSortStatusJsonService.handleRequest] error : " + e.getMessage(), 2));
        }
    }

    private void autoSlotPackage() {
        try {
            String lastMode = SortControllerManager.getInstance().getCurrentSortInfoMode();
            if (lastMode.equals("Yunda")) {
                int slotNumber = SorterCommonParams.getInstance().getSlotNumber();
                for (int i = 1; i < slotNumber; ++i) {
                    SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(String.valueOf(i));
                    SortControllerManager.getInstance().onSlotPackMessage(slotInfo);
                }
            }
        }
        catch (Exception e) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[SetSortStatusJsonService.autoSlotPackage] error : " + e.getMessage(), 2));
        }
    }
}

