/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.httpservice.best;

import com.simba.common.httpserver.HttpChannelManager;
import com.simba.common.httpserver.httpservice.HttpService;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.data.SlotInfo;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.json.JSONException;
import org.json.JSONObject;

public class BestSlotBindHttpService
implements HttpService {
    public static final String NAME = "/Pack/PortBinding";
    private static final Logger logger = Logger.getLogger(BestSlotBindHttpService.class);

    @Override
    public void handleRequest(Channel connection, Object contentStr, HttpRequest request) {
        try {
            String slotBinding = "";
            String[] content = ((String)contentStr).split("\\r\\n\\r\\n");
            for (int i = 0; i < content.length; ++i) {
                if (!content[i].contains("bindingTime")) continue;
                String[] msg = content[i].split("\\r\\n");
                for (int b = 0; b < msg.length; ++b) {
                    if (!msg[b].contains("bindingTime")) continue;
                    slotBinding = msg[b];
                }
            }
            JSONObject requestObj = new JSONObject(slotBinding);
            String sortPortCode = requestObj.getString("sortPortCode");
            String slotId = String.valueOf(Integer.parseInt(this.parseSlotId(sortPortCode)));
            String packCode = requestObj.getString("packageCode");
            SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotId);
            if (slotInfo == null) {
                return;
            }
            slotInfo.setPackCode(packCode);
            slotInfo.setRequestObj(requestObj);
            SortControllerManager.getInstance().onSlotBindMessage(slotInfo);
            this.sendBindResponse(connection);
        }
        catch (JSONException ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Slot bind Json Service Error : exception info : ", 2));
        }
    }

    private String parseSlotId(String sortPortCode) {
        int len = sortPortCode.length();
        return sortPortCode.substring(len - 3, len);
    }

    private void sendBindResponse(Channel connection) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setStatus(HttpResponseStatus.OK);
        response.setHeader("Content-Encoding", "UTF-8");
        response.setHeader("Content-Type", "application/json");
        HashMap<String, String> dummyContentMap = new HashMap<String, String>();
        dummyContentMap.put("status", "1");
        dummyContentMap.put("result", "success");
        JSONObject dummyContentObj = new JSONObject(dummyContentMap);
        String dummyContentStr = dummyContentObj.toString();
        ByteBuffer rawContent = ByteBuffer.wrap(dummyContentStr.getBytes());
        rawContent.rewind();
        ChannelBuffer channelBuffer = ChannelBuffers.wrappedBuffer(rawContent);
        response.setHeader("Content-Length", rawContent.limit());
        response.setContent(channelBuffer);
        HttpChannelManager.getInstance().commitResponse(connection, response, false);
    }
}

