/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.httpservice;

import com.simba.common.RequestHandler;
import com.simba.common.httpserver.httpservice.DefaultHttpServiceContainer;
import com.simba.common.httpserver.httpservice.HttpService;
import com.simba.common.httpserver.httpservice.HttpServiceContainer;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.thread.CommonExecutorFactory;
import com.simba.common.thread.CounterThreadFactory;
import com.simba.server.httpservice.EchoHttpService;
import com.simba.server.httpservice.ErrorHttpService;
import com.simba.server.httpservice.best.BestFullOutRepackService;
import com.simba.server.httpservice.best.BestSlotBindHttpService;
import com.simba.server.httpservice.best.simulate.BestArrialHttpService;
import com.simba.server.httpservice.best.simulate.BestBillcodeWeightHttpService;
import com.simba.server.httpservice.best.simulate.BestDepartureHttpService;
import com.simba.server.httpservice.best.simulate.BestSortResultHttpService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.util.CharsetUtil;

public class HttpServiceManager
implements RequestHandler {
    protected static final Logger logger = Logger.getLogger(HttpServiceManager.class);
    private static int ASYNC_HTTP_EXECUTOR_POOL_SIZE = 4;
    private static final String ASYNC_OPERATION_EXECUTOR_NAME = "Http-Service-Task";
    private Executor asyncWebServiceExecutor;
    private BlockingQueue<Runnable> asyncWebServiceOperationQueue;
    private final HttpServiceContainer container = new DefaultHttpServiceContainer();

    public static HttpServiceManager getInstance() {
        return WebServiceManagerHolder.INSTANCE;
    }

    private HttpServiceManager() {
    }

    @Override
    public void handleRequest(final Channel channel, Object requestObj) {
        final HttpRequest request = (HttpRequest)requestObj;
        this.runAsyncHttpTask(new Runnable(){

            @Override
            public void run() {
                block10: {
                    try {
                        ChannelBuffer contentBuffer = request.getContent();
                        HttpService accessor = null;
                        String contentStr = "No Content";
                        String methodName = request.getMethod().getName();
                        if (!methodName.equalsIgnoreCase("GET") && !contentBuffer.readable()) {
                            accessor = HttpServiceManager.this.container.getHttpService("ErrorRequestAccessor");
                            accessor.handleRequest(channel, null, request);
                            return;
                        }
                        if (!methodName.equalsIgnoreCase("GET")) {
                            contentStr = contentBuffer.toString(CharsetUtil.UTF_8);
                            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "The Request Content is : " + contentStr, 3));
                        }
                        try {
                            String[] uriName;
                            String name = request.getUri();
                            if (methodName.equals("GET") && (uriName = name.split("\\?")) != null && uriName.length > 0) {
                                name = uriName[0];
                                if (uriName.length > 1) {
                                    contentStr = uriName[1];
                                }
                            }
                            if ((accessor = HttpServiceManager.this.container.getHttpService(name)) == null) {
                                accessor = HttpServiceManager.this.container.getHttpService("ErrorRequestAccessor");
                            }
                        }
                        catch (Exception ex) {
                            accessor = HttpServiceManager.this.container.getHttpService("ErrorRequestAccessor");
                        }
                        if (accessor != null) {
                            accessor.handleRequest(channel, contentStr, request);
                        }
                    }
                    catch (Exception expt) {
                        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Http Request Content is : " + expt.getMessage(), 3));
                        if (!(expt instanceof InterruptedException)) break block10;
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
    }

    @Override
    public void onChannelConnected(Channel channel) {
    }

    @Override
    public void onChannelDisconnected(Channel channel) {
    }

    public void init() {
        this.initHttpServiceContainer();
        this.initAsyncHttpTaskExcutor();
    }

    public void postInitProcess() {
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "HttpServiceManager initialize successfully", 3));
    }

    private void initAsyncHttpTaskExcutor() {
        this.asyncWebServiceOperationQueue = new LinkedBlockingQueue<Runnable>();
        this.asyncWebServiceExecutor = CommonExecutorFactory.newFixedThreadPool(ASYNC_HTTP_EXECUTOR_POOL_SIZE, new CounterThreadFactory(ASYNC_OPERATION_EXECUTOR_NAME), this.asyncWebServiceOperationQueue);
    }

    private void initHttpServiceContainer() {
        this.container.addHttpService("EchoRequest", new EchoHttpService());
        this.container.addHttpService("ErrorRequestAccessor", new ErrorHttpService());
        this.container.addHttpService("/Pack/PortBinding", new BestSlotBindHttpService());
        this.container.addHttpService("/Pack/FalloutRepacking", new BestFullOutRepackService());
        this.container.addHttpService("/api/box/data/commonData", new BestArrialHttpService());
        this.container.addHttpService("/api/wcs/sorting/departures", new BestDepartureHttpService());
        this.container.addHttpService("/api/wcs/sorting/results", new BestSortResultHttpService());
        this.container.addHttpService("/api/wcs/bill-weight", new BestBillcodeWeightHttpService());
    }

    private void runAsyncHttpTask(Runnable task) {
        try {
            if (task != null) {
                this.asyncWebServiceExecutor.execute(task);
            }
        }
        catch (Exception e) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "run async task to access http request failed : " + e.getMessage(), 2));
        }
    }

    private static class WebServiceManagerHolder {
        private static final HttpServiceManager INSTANCE = new HttpServiceManager();

        private WebServiceManagerHolder() {
        }
    }
}

