/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.server.ServerManager;
import com.simba.server.components.CommonDefines;
import com.simba.server.components.SorterCommonParams;
import org.jboss.netty.channel.Channel;

public class SorterParamDecoder
implements Decoder {
    public static final String NAME = "SorterParam";
    private static final int MAX_LOOP_CIRCLE_BUFFER_SIZE = 1;
    private static final int SORTER_PARAMS_COMMAND_BUFFER_SIZE = 1;

    public static SorterParamDecoder getSorterParamDecoder() {
        return SorterParamDecoderHolder.INSTANCE;
    }

    private SorterParamDecoder() {
    }

    @Override
    public void doDecode(Channel channel, Object message) {
        int position = 0;
        int contentSize = CommonDefines.REPLY_HEADER.length + 1 + 1 + 1;
        byte[] replyBuffer = new byte[contentSize];
        byte[] header = CommonDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{11};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        byte[] maxLoops = new byte[]{(byte)SorterCommonParams.getInstance().getTurnNumber()};
        System.arraycopy(maxLoops, 0, replyBuffer, position += command.length, maxLoops.length);
        int serialNumber = ServerManager.getInstance().getSerialNumber();
        byte[] serialNumberBuf = new byte[]{(byte)serialNumber};
        System.arraycopy(serialNumberBuf, 0, replyBuffer, position += maxLoops.length, serialNumberBuf.length);
        position += serialNumberBuf.length;
        ServerManager.getInstance().setSerialNumber(++serialNumber);
        FrameChannelManager.getInstance().commitResponse(channel, replyBuffer, false);
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static class SorterParamDecoderHolder {
        private static SorterParamDecoder INSTANCE = new SorterParamDecoder();

        private SorterParamDecoderHolder() {
        }
    }
}

