/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.utils.FrameUtils;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.data.PlcInfo;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.controllers.sto.data.UtilityHelper;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class SlotPackDecoder
implements Decoder {
    public static final String NAME = "SlotPack";
    protected static final Logger logger = Logger.getLogger(SlotPackDecoder.class);
    private static final int SLOT_ID_POSITION = 3;

    public static SlotPackDecoder getDecoderInstance() {
        return SlotPackDecoderHolder.INSTANCE;
    }

    private SlotPackDecoder() {
    }

    @Override
    public void doDecode(Channel connection, Object message) {
        byte[] contentOri = null;
        try {
            byte[] content;
            contentOri = content = (byte[])message;
            int slotIdValue = FrameUtils.getInstance().getUnsignedShortBigEndian(3, content);
            PlcInfo plcInfo = SlotManager.getInstance().getPlcInfoByChannel(connection);
            if (plcInfo == null) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Slot Pack Error -- plcInfo==null) : connection is" + connection.getRemoteAddress().toString(), 2));
                return;
            }
            String slotKey = String.valueOf(slotIdValue += plcInfo.getAdjustSlotNumber());
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "\u9501\u683c\u6d88\u606f \u683c\u53e3 " + slotKey, 1));
            SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotKey);
            if (slotInfo == null) {
                return;
            }
            SortControllerManager.getInstance().onSlotPackMessage(slotInfo);
        }
        catch (Exception ex) {
            String strContent = UtilityHelper.getInstance().byte2hex(contentOri);
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Slot Pack Error -- Exception : " + ex.getMessage() + " content is:" + strContent, 2));
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static class SlotPackDecoderHolder {
        private static final SlotPackDecoder INSTANCE = new SlotPackDecoder();

        private SlotPackDecoderHolder() {
        }
    }
}

