/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.utils.FrameUtils;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.framedecoder.decoders.SlotFullDecoder;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class SlotNormalDecoder
implements Decoder {
    public static final String NAME = "SlotNormal";
    protected static final Logger logger = Logger.getLogger(SlotNormalDecoder.class);
    private static final int SLOT_ID_POSITION = 3;

    public static SlotNormalDecoder getDecoderInstance() {
        return SlotNormalDecoderHolder.INSTANCE;
    }

    @Override
    public void doDecode(Channel connection, Object message) {
        byte[] content = (byte[])message;
        int slotIdValue = FrameUtils.getInstance().getUnsignedShortBigEndian(3, content);
        String slotKey = String.valueOf(slotIdValue);
        SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotKey);
        if (slotInfo == null) {
            return;
        }
        SortControllerManager.getInstance().onSlotUnlockMessage(slotInfo);
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(SlotFullDecoder.logger), "normal slot " + slotKey, 1));
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static class SlotNormalDecoderHolder {
        private static final SlotNormalDecoder INSTANCE = new SlotNormalDecoder();

        private SlotNormalDecoderHolder() {
        }
    }
}

