/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.utils.FrameUtils;
import com.simba.server.components.PlatInstance;
import com.simba.server.components.PlatInstanceManager;
import com.simba.server.components.SlotManager;
import com.simba.server.components.data.PlcInfo;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class PacketOnDecoder
implements Decoder {
    public static final String NAME = "PacketOn";
    protected static final Logger logger = Logger.getLogger(PacketOnDecoder.class);
    private static final int BARCODE_LEN_POSITION = 7;
    private static final int BARCODE_POSITION = 8;
    private static final int CAR_ID_POSITION = 3;
    private static final int PACKET_ON_MODE_SCANNED = 3;
    private static final int PLAT_ID_POSITION = 5;
    private static final int PLAT_MODE_POSITION = 6;

    public static PacketOnDecoder getDecoderInstance() {
        return PacketOnDecoderHolder.INSTANCE;
    }

    private PacketOnDecoder() {
    }

    @Override
    public void doDecode(Channel connection, Object message) {
        try {
            int platIdBinary;
            byte[] content = (byte[])message;
            PlcInfo plcInfo = SlotManager.getInstance().getPlcInfoByChannel(connection);
            if (plcInfo == null) {
                return;
            }
            int carIdValue = FrameUtils.getInstance().getUnsignedShortBigEndian(3, content);
            String carId = String.valueOf(carIdValue);
            int phySicalPlatID = platIdBinary = content[5];
            String platId = String.valueOf(platIdBinary += plcInfo.getAdjustPlatNumber());
            byte modeBinary = content[6];
            String mode = String.valueOf(modeBinary);
            byte barcodeLen = content[7];
            String barcode = new String(content, 8, (int)barcodeLen, "UTF-8");
            int plcIdLenPosition = 8 + barcodeLen;
            int plcIdPosition = 8 + barcodeLen + 1;
            byte plcIdLen = content[plcIdLenPosition];
            String plcId = new String(content, plcIdPosition, (int)plcIdLen, "UTF-8");
            PlatInstance platInstance = PlatInstanceManager.getInstance().getPlatById(platId);
            if (platInstance == null) {
                return;
            }
            if (modeBinary == 3) {
                platInstance.handlePacketOnCommand(platId, barcode, carId, plcId, mode, plcInfo.getCarFlag(), String.valueOf(phySicalPlatID));
                this.sendPacketEchoToPlc(connection, content);
            } else {
                this.sendErrorPlatModeToPLC();
            }
            this.sendPacketOnInfoToClient(carId, platId, mode, barcode);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "PacketOn Decoder Error : exception info : " + ex.getMessage(), 2));
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private void sendErrorPlatModeToPLC() {
    }

    private void sendPacketEchoToPlc(Channel channel, byte[] content) {
        if (content == null || content.length < 2) {
            return;
        }
        content[0] = 2;
        content[1] = 1;
        FrameChannelManager.getInstance().commitResponse(channel, content, false);
    }

    private void sendPacketOnInfoToClient(String carId, String platId, String mode, String barcode) {
        try {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[SJ-],[ carId: " + carId + ",platId: " + platId + ",mode: " + mode + ",barcode: " + barcode + "]", 3));
            JSONObject sortInfoObj = new JSONObject();
            sortInfoObj.put("ServiceName", "PacketOnInfo");
            sortInfoObj.put("carId", carId);
            sortInfoObj.put("platId", platId);
            sortInfoObj.put("platMode", mode);
            sortInfoObj.put("barcode", barcode);
            String sortInfoStr = sortInfoObj.toString();
            for (Channel channel : JsonChannelManager.getInstance().getChannelList()) {
                JsonChannelManager.getInstance().commitResponse(channel, sortInfoStr.getBytes(), false);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[PacketOnDecoder.sendPacketOnInfoToClient],[Packet on info send to remote logger error : " + ex.getMessage() + "]", 2));
        }
    }

    private static class PacketOnDecoderHolder {
        private static final PacketOnDecoder INSTANCE = new PacketOnDecoder();

        private PacketOnDecoderHolder() {
        }
    }
}

