/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.framedecoder.decoders;

import com.simba.common.decoder.Decoder;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.utils.FrameUtils;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.SortInfoManager;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.PlcInfo;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.SortInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class PacketOffDecoder
implements Decoder {
    public static final String NAME = "PacketOff";
    protected static final Logger logger = Logger.getLogger(PacketOffDecoder.class);
    private static final int DROPPED_CAR_ID_POSITION = 3;
    private static final int DROPPED_PLC_ID_LEN_POSITION = 11;
    private static final int DROPPED_PLC_ID_POSITION = 12;
    private static final int DROPPED_SLOT_ID_POSITION = 8;

    public static PacketOffDecoder getDecoderInstance() {
        return PacketOffDecoderHolder.INSTANCE;
    }

    private PacketOffDecoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDecode(Channel channel, Object message) {
        byte[] content = (byte[])message;
        int carIdBinary = FrameUtils.getInstance().getUnsignedShortBigEndian(3, content);
        String carId = String.valueOf(carIdBinary);
        PlcInfo plcInfo = SlotManager.getInstance().getPlcInfoByChannel(channel);
        if (plcInfo == null) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch an error in PacketOffecode: plcinfo==null connected plc is " + channel.getRemoteAddress().toString(), 2));
        }
        int droppedSlotId = FrameUtils.getInstance().getUnsignedShortBigEndian(8, content);
        if (plcInfo != null) {
            droppedSlotId += plcInfo.getAdjustSlotNumber();
            carId = plcInfo.getCarFlag() + "-" + carId;
        }
        String droppedSlotIdKey = String.valueOf(droppedSlotId);
        SortInfo sortInfo = SortInfoManager.getInstance().getSortInfo(carId);
        if (sortInfo == null) {
            return;
        }
        sortInfo.setDroppedSlotId(droppedSlotId);
        SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(droppedSlotIdKey);
        if (slotInfo != null) {
            sortInfo.setPackCode(slotInfo.getPackCode());
            int mailCount = slotInfo.getMailCount();
            slotInfo.setMailCount(++mailCount);
        }
        try {
            byte plcIdLen = content[11];
            String plcId = new String(content, 12, (int)plcIdLen, "UTF-8");
            if (!plcId.equals(sortInfo.getPlcId())) {
                // empty if block
            }
            byte turnNumber = content[12 + plcIdLen];
            sortInfo.setTurnNumber(turnNumber);
            sortInfo.setObr(0);
            int droppedDeflection = 0;
            sortInfo.setDroppedErrorCode(droppedDeflection);
            sortInfo.setTimePacketOff(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
            sortInfo.setTimestampPacketOff(SorterProtocolCreator.getInstance().createCurrentTimeStamp());
            SortControllerManager.getInstance().onPacketOffMessage(sortInfo);
            FrameChannelManager.getInstance().commitResponse(channel, content, false);
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "[LG-],[ carId: " + carId + ",plcInfo: " + plcInfo + ",droppedSlotId: " + droppedSlotId + ",barcode:" + sortInfo.getBarcode() + ",packageCode: " + slotInfo.getPackCode() + "]", 3));
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch an exception in PacketOffecode:" + ex.getMessage(), 2));
        }
        finally {
            SortInfoManager.getInstance().removeSortInfo(carId);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static class PacketOffDecoderHolder {
        private static final PacketOffDecoder INSTANCE = new PacketOffDecoder();

        private PacketOffDecoderHolder() {
        }
    }
}

