/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.yunda;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SlotManager;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.controllers.ISlotPackController;
import com.simba.server.netclient.DefaultClientManager;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public class YundaSlotPackController
implements ISlotPackController {
    private static final Logger logger = Logger.getLogger(YundaSlotPackController.class);

    @Override
    public void onSlotPackMessage(SlotInfo slotInfo) {
        this.restoreYundaSlotBindInfo(slotInfo);
        this.restoreYundaSlotPackInfo(slotInfo);
        this.sendLockSlotMsgToYunda(slotInfo);
        this.uploadPackageToYunda(slotInfo);
        slotInfo.setPackCode(SlotManager.getInstance().createSlotBindUUID());
    }

    private void restoreYundaSlotBindInfo(SlotInfo slotInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("YundaSlotBind", slotInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private void restoreYundaSlotPackInfo(SlotInfo slotInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("YundaSlotPack", slotInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private void sendLockSlotMsgToYunda(SlotInfo slotInfo) {
        try {
            StringBuilder sb = new StringBuilder();
            long time = System.currentTimeMillis();
            String now = String.valueOf(time);
            String flag = now.substring(10, 13);
            sb.append("LC-" + flag + ":");
            sb.append("1,");
            sb.append(slotInfo.getSlotId() + ",");
            sb.append(new SimpleDateFormat("yyyyMMddHHmmss").format(time));
            String lockSlotMsg = sb.toString();
            DefaultClientManager.getInstance().sendUploadMsgToDefaultClient(lockSlotMsg.getBytes());
        }
        catch (Exception e) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "YundaSlotPackController sendLockSlotMsgToYunda Error -- Exception : " + e.getMessage(), 2));
        }
    }

    private void uploadPackageToYunda(SlotInfo slotInfo) {
        try {
            StringBuilder sb = new StringBuilder();
            long time = System.currentTimeMillis();
            String now = String.valueOf(time);
            String flag = now.substring(8, 13);
            sb.append("SB-" + flag + ":");
            String bagId = slotInfo.getPackCode().replace("-", "").substring(0, 30);
            sb.append(bagId + ",");
            sb.append(slotInfo.getSlotId() + ",");
            sb.append(new SimpleDateFormat("yyyyMMddHHmmss").format(time) + ",");
            sb.append(slotInfo.getPackageNum() + ",");
            sb.append("1,");
            sb.append("0");
            String packagesInfo = sb.toString();
            if (Integer.parseInt(slotInfo.getPackageNum()) > 0) {
                DefaultClientManager.getInstance().sendUploadMsgToDefaultClient(packagesInfo.getBytes());
            }
        }
        catch (Exception e) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "YundaSlotPackController uploadPackageToYunda Error -- Exception : " + e.getMessage(), 2));
        }
    }
}

