/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.yunda;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.IScannedController;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class YundaScannedController
implements IScannedController {
    private static final Logger logger = Logger.getLogger(YundaScannedController.class);

    @Override
    public void onScannedMessage(SortInfo sortInfo) {
        try {
            JSONObject dataObj = sortInfo.getDataObj();
            if (dataObj == null) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Yunda Scanned Request Object is NULL : " + sortInfo.getBarcode(), 3));
                return;
            }
            dataObj.put("sortMode", "MES-MODE");
            sortInfo.getSlotsList().clear();
            String slotsContent = dataObj.getString("slotsContent");
            if (slotsContent == null || slotsContent.equals("")) {
                sortInfo.getSlotsList().add(0);
            } else {
                String[] slots;
                for (String slotContent : slots = slotsContent.split("\\|")) {
                    int slotValue = Integer.parseInt(slotContent);
                    sortInfo.getSlotsList().add(slotValue);
                }
            }
            this.sendSlotsContentToPLC(sortInfo);
            this.restoreYundaScannedInfo(sortInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Scanned Message In YundaScanned Handler Error -- Exception : " + ex, 2));
        }
    }

    private void restoreYundaScannedInfo(SortInfo sortInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("YundaScanned", sortInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private void sendSlotsContentToPLC(SortInfo sortInfo) {
        Channel[] clients;
        byte[] replyBuffer = SorterProtocolCreator.getInstance().createSortInfoWithPlat(sortInfo);
        for (Channel client : clients = FrameChannelManager.getInstance().getChannelList()) {
            FrameChannelManager.getInstance().commitResponse(client, replyBuffer, false);
        }
    }
}

