/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.yunda;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.IPacketOnController;
import com.simba.server.controllers.yunda.YundaCPModeManager;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class YundaPacketOnController
implements IPacketOnController {
    private static final Logger logger = Logger.getLogger(YundaPacketOnController.class);

    @Override
    public void onPacketOnMessage(SortInfo sortInfo) {
        try {
            JSONObject dataObj = sortInfo.getDataObj();
            if (dataObj == null) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Yunda Packet On Request Object is NULL : " + sortInfo.getBarcode(), 3));
                return;
            }
            String slotsContent = dataObj.getString("slotsContent");
            if (slotsContent == null || slotsContent.equals("")) {
                YundaCPModeManager.getInstance().addSortInfoToCP(sortInfo);
            }
            this.restoreYundaPacketOn(sortInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Yunda Packet On Message In YundaPacketOn Handler Error -- Exception : " + ex, 2));
        }
    }

    private void restoreYundaPacketOn(SortInfo sortInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("YundaPacketOn", sortInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }
}

