/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.yunda;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SlotManager;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.IPacketOffController;
import com.simba.server.controllers.yunda.YundaCPModeManager;
import com.simba.server.netclient.DefaultClientManager;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class YundaPacketOffController
implements IPacketOffController {
    private static final Logger logger = Logger.getLogger(YundaPacketOffController.class);

    @Override
    public void onPacketOffMessage(SortInfo sortInfo) {
        try {
            JSONObject dataObj = sortInfo.getDataObj();
            if (dataObj == null) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Yunda Packet Off Request Object is NULL : " + sortInfo.getBarcode(), 3));
                return;
            }
            this.sendSortResultToYunda(sortInfo);
            this.restoreYundaPacketOff(sortInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Yunda PacketOff Message In YundaPacketOff Handler Error -- Exception : " + ex.getMessage(), 2));
        }
    }

    private String dropInTrashSlotReasonByComplement(int droppedSlot, JSONObject dataObj) {
        StringBuilder sb = new StringBuilder();
        try {
            String slotFlag = dataObj.getString("slotFlag");
            if ((SlotManager.getInstance().droppedSlotIsLockoverTime(droppedSlot).booleanValue() || SlotManager.getInstance().droppedSlotIsNoInfo(droppedSlot).booleanValue()) && slotFlag != null && slotFlag.equals("1")) {
                if (dataObj.get("slotsContent") != null && !dataObj.has("cpFlag")) {
                    sb.append("0,");
                    sb.append("1,");
                    sb.append("MES,");
                } else {
                    if (dataObj.get("cpFlag") != null && dataObj.get("cpFlag").equals("8")) {
                        sb.append("0,");
                        sb.append("8,");
                        sb.append("VCS,");
                    }
                    if (dataObj.get("cpFlag") != null && dataObj.get("cpFlag").equals("9")) {
                        sb.append("0,");
                        sb.append("9,");
                        sb.append("VCS,");
                    }
                    if (dataObj.get("cpFlag") != null && (dataObj.get("cpFlag").equals("0") || dataObj.get("cpFlag").equals("none"))) {
                        if (SlotManager.getInstance().droppedSlotIsLockoverTime(droppedSlot).booleanValue()) {
                            sb.append("0,");
                            sb.append("3,");
                            sb.append("PLC,");
                        }
                        if (SlotManager.getInstance().droppedSlotIsNoInfo(droppedSlot).booleanValue()) {
                            sb.append("0,");
                            sb.append("2,");
                            sb.append("PLC,");
                        }
                    }
                }
            }
            if (!SlotManager.getInstance().droppedSlotIsNoInfo(droppedSlot).booleanValue() && !SlotManager.getInstance().droppedSlotIsLockoverTime(droppedSlot).booleanValue()) {
                sb.append("1,");
                sb.append("0,");
                sb.append("VCS,");
            }
        }
        catch (Exception e) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Yunda PacketOff Message In dropInTrashSlotReasonByComplement  Error -- Exception : " + e.getMessage(), 2));
        }
        return sb.toString();
    }

    private String dropInTrashSlotReasonByMES(int droppedSlot, JSONObject dataObj) {
        StringBuilder sb = new StringBuilder();
        try {
            String slotFlag = dataObj.getString("slotFlag");
            if (!SlotManager.getInstance().droppedSlotIsNoInfo(droppedSlot).booleanValue() && !SlotManager.getInstance().droppedSlotIsLockoverTime(droppedSlot).booleanValue()) {
                sb.append("1,");
                sb.append("0,");
                sb.append("MES,");
            }
            if (SlotManager.getInstance().droppedSlotIsLockoverTime(droppedSlot).booleanValue() || SlotManager.getInstance().droppedSlotIsNoInfo(droppedSlot).booleanValue()) {
                if (slotFlag != null && slotFlag.equals("1")) {
                    if (dataObj.get("slotsContent") != null || !dataObj.get("slotsContent").equals("")) {
                        sb.append("0,");
                        sb.append("12,");
                        sb.append("MES,");
                    }
                } else {
                    if (SlotManager.getInstance().droppedSlotIsLockoverTime(droppedSlot).booleanValue()) {
                        sb.append("0,");
                        sb.append("3,");
                        sb.append("PLC,");
                    }
                    if (SlotManager.getInstance().droppedSlotIsNoInfo(droppedSlot).booleanValue()) {
                        sb.append("0,");
                        sb.append("2,");
                        sb.append("PLC,");
                    }
                }
            }
        }
        catch (Exception e) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Yunda PacketOff Message In dropInTrashSlotReasonByMES Error -- Exception : " + e.getMessage(), 2));
        }
        return sb.toString();
    }

    private void restoreYundaPacketOff(SortInfo sortInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("YundaPacketOff", sortInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private void sendSortResultToYunda(SortInfo sortInfo) {
        try {
            JSONObject dataObj = sortInfo.getDataObj();
            int droppedSlot = sortInfo.getDroppedSlotId();
            StringBuilder sb = new StringBuilder();
            long time = System.currentTimeMillis();
            String now = String.valueOf(time);
            String flag = now.substring(8, 13);
            String barcode = sortInfo.getBarcode();
            sb.append("SM-" + flag + ":");
            String bagId = sortInfo.getPackCode().replace("-", "").substring(0, 30);
            sb.append(bagId + ",");
            sb.append(barcode + ",");
            sb.append("0,");
            sb.append(dataObj.get("businessType") + ",");
            sb.append(dataObj.get("logicSlot") + ",");
            sb.append(droppedSlot + ",");
            sb.append(sortInfo.getTimePacketOff() + ",");
            sb.append(sortInfo.getPlatId() + ",");
            sb.append("0,");
            sb.append("0,");
            sb.append("0,");
            sb.append("0,");
            sb.append("0,");
            sb.append("1,");
            sb.append("0,");
            if (YundaCPModeManager.getInstance().ComplementListContainBarcode(barcode).booleanValue()) {
                sb.append(this.dropInTrashSlotReasonByComplement(droppedSlot, dataObj));
            }
            if (!YundaCPModeManager.getInstance().ComplementListContainBarcode(barcode).booleanValue()) {
                sb.append(this.dropInTrashSlotReasonByMES(droppedSlot, dataObj));
            }
            sb.append("0,");
            sb.append(sortInfo.getTimePacketOff() + ",");
            sb.append(sortInfo.getTimePacketOn() + ",");
            sb.append("3,");
            sb.append(sortInfo.getPlatId() + ",");
            sb.append(sortInfo.getTimeScanned() + ",");
            sb.append(sortInfo.getCarId() + ",");
            sb.append("0,");
            sb.append("0,");
            sb.append("0,");
            sb.append("1,");
            sb.append(sortInfo.getObr() + "/2");
            byte[] content = sb.toString().getBytes();
            DefaultClientManager.getInstance().sendUploadMsgToDefaultClient(content);
            YundaCPModeManager.getInstance().removeSortInfoByBarcode(sortInfo.getBarcode());
        }
        catch (Exception e) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Yunda PacketOff Message In sendSortResultToYunda Error -- Exception : " + e.getMessage(), 2));
        }
    }
}

