/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.yunda;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.IComplementController;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class YundaComplementController
implements IComplementController {
    private static final Logger logger = Logger.getLogger(YundaComplementController.class);

    @Override
    public void onComplementMessage(SortInfo sortInfo) {
        try {
            JSONObject dataObj = sortInfo.getDataObj();
            String slotsContent = dataObj.getString("slotsContent");
            if (slotsContent != null && !slotsContent.equals("")) {
                String[] slotMessage;
                sortInfo.getSlotsList().clear();
                for (String slotStr : slotMessage = slotsContent.split("\\|")) {
                    int slot = Integer.parseInt(slotStr);
                    sortInfo.getSlotsList().add(slot);
                }
            }
            dataObj.put("sortMode", "CP-MODE");
            sortInfo.setTimeComplement(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
            if (sortInfo.getComplementResult().equals("success")) {
                this.sendComplementToPLC(sortInfo);
            }
            this.restoreYundaScannedInfo(sortInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Yunda Complement Message In Yunda Handler Error -- Exception : " + ex, 2));
        }
    }

    private void restoreYundaScannedInfo(SortInfo sortInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("YundaComplement", sortInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private void sendComplementToPLC(SortInfo sortInfo) {
        Channel[] clients;
        byte[] replyBuffer = SorterProtocolCreator.getInstance().createSortInfoWithCarID(sortInfo);
        for (Channel client : clients = FrameChannelManager.getInstance().getChannelList()) {
            FrameChannelManager.getInstance().commitResponse(client, replyBuffer, false);
        }
    }
}

