/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.yunda;

import com.simba.server.components.data.SortInfo;
import java.util.concurrent.ConcurrentHashMap;

public class YundaCPModeManager {
    private final ConcurrentHashMap<String, SortInfo> complementList = new ConcurrentHashMap();

    public static YundaCPModeManager getInstance() {
        return YundaCPCodeManagerHolder.INSTANCE;
    }

    private YundaCPModeManager() {
    }

    public void addSortInfoToCP(SortInfo sortInfo) {
        if (sortInfo == null) {
            return;
        }
        String barcode = sortInfo.getBarcode();
        if (barcode == null || barcode.equals("")) {
            return;
        }
        this.complementList.put(barcode, sortInfo);
    }

    public Boolean ComplementListContainBarcode(String barcode) {
        Boolean ret = false;
        if (this.complementList.containsKey(barcode)) {
            ret = true;
        }
        return ret;
    }

    public SortInfo getSortInfoByBarcode(String barcode) {
        if (barcode == null || barcode.equals("")) {
            return null;
        }
        return this.complementList.get(barcode);
    }

    public SortInfo removeSortInfoByBarcode(String barcode) {
        if (barcode == null || barcode.equals("")) {
            return null;
        }
        return this.complementList.remove(barcode);
    }

    private static class YundaCPCodeManagerHolder {
        private static final YundaCPModeManager INSTANCE = new YundaCPModeManager();

        private YundaCPCodeManagerHolder() {
        }
    }
}

