/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.sto.data;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.data.SortInfo;
import com.simba.server.components.data.SortPlanItem;
import com.simba.server.components.data.StoSortPlanMap;
import com.simba.server.controllers.sto.data.StoSlotNextStaMap;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class STOSlotManager {
    private static final Logger logger = Logger.getLogger(STOSlotManager.class);
    private HashMap<String, String> mapBindPacket = new HashMap();
    private HashMap<String, String> mapPacketSlot = new HashMap();
    private HashMap<String, String> mapSlotNextStaCodeDep = new HashMap();
    private HashMap<String, String> mapSlotNextStaCodeArriv = new HashMap();
    private ConcurrentHashMap<String, String> stoSortPlanA = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> stoSortPlanD = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> stoSortPlanDIntercept = new ConcurrentHashMap();
    private HashMap<String, Integer> platStatics = new HashMap();
    private HashMap<String, String> barcodeIntercept = new HashMap();
    private String stoPattern = "";
    public Long LastPacketOffTime = null;

    public static STOSlotManager getInstance() {
        return SlotManagerHolder.INSTANCE;
    }

    public ConcurrentHashMap<String, String> getStoSortPlanA() {
        return this.stoSortPlanA;
    }

    public ConcurrentHashMap<String, String> getStoSortPlanD() {
        return this.stoSortPlanD;
    }

    public HashMap<String, String> getMapBindPacket() {
        return this.mapBindPacket;
    }

    public void setMapBindPacket(HashMap<String, String> mapBindPacket) {
        this.mapBindPacket = mapBindPacket;
    }

    public HashMap<String, String> getMapSlotNextStaCodeDep() {
        return this.mapSlotNextStaCodeDep;
    }

    public void setMapSlotNextStaCodeDep(HashMap<String, String> mapSlotNextStaCodeDep) {
        this.mapSlotNextStaCodeDep = mapSlotNextStaCodeDep;
    }

    public HashMap<String, String> getMapSlotNextStaCodeArriv() {
        return this.mapSlotNextStaCodeArriv;
    }

    public void setMapSlotNextStaCodeArriv(HashMap<String, String> mapSlotNextStaCodeArriv) {
        this.mapSlotNextStaCodeArriv = mapSlotNextStaCodeArriv;
    }

    public void initSlotNextStaCode() {
        this.initStoSlotNextStaCodeDep();
        this.initStoSlotNextStaCodeArriv();
    }

    public void initStoSlotNextStaCodeDep() {
        StoSlotNextStaMap SlotNextStaMap = new StoSlotNextStaMap(this.mapSlotNextStaCodeDep);
        ICommand command = CommandCreator.getInstance().createCommand("STOSlotNextStaCodeD", SlotNextStaMap);
        Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
        if (ret.booleanValue()) {
            this.mapSlotNextStaCodeDep = SlotNextStaMap.getSlotNextStaMap();
        }
    }

    public void initBarcodeIntercept() {
        ICommand command = CommandCreator.getInstance().createCommand("stoBarcodeInterceptReset", "stoBarcodeInterceptReset");
        Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
    }

    public void initStoSlotNextStaCodeArriv() {
        StoSlotNextStaMap SlotNextStaMap = new StoSlotNextStaMap(this.mapSlotNextStaCodeArriv);
        ICommand command = CommandCreator.getInstance().createCommand("STOSlotNextStaCodeA", SlotNextStaMap);
        Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
        if (ret.booleanValue()) {
            this.mapSlotNextStaCodeArriv = SlotNextStaMap.getSlotNextStaMap();
        }
    }

    private void initStoSortPlanDIntercet() {
        this.stoSortPlanDIntercept.clear();
        StoSortPlanMap sortPlanMap = new StoSortPlanMap(this.stoSortPlanDIntercept);
        ICommand command = CommandCreator.getInstance().createCommand("STOSortPlanDInterceptReset", sortPlanMap);
        Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
        if (ret.booleanValue()) {
            this.stoSortPlanDIntercept = sortPlanMap.getSortPlanMap();
        }
    }

    public void resetStoIntercept() {
        this.initStoSortPlanDIntercet();
        this.initBarcodeIntercept();
    }

    public void resetStoSortPlan() {
        this.stoSortPlanA.clear();
        this.stoSortPlanD.clear();
        this.stoSortPlanDIntercept.clear();
        this.mapPacketSlot.clear();
        this.initStoSortPlanDIntercet();
        this.initBarcodeIntercept();
    }

    public void updateSlotStatus() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String strNow = df.format(new Date());
        try {
            Date dnow = df.parse(strNow);
            Calendar cal = Calendar.getInstance();
            cal.setTime(dnow);
            cal.add(5, -1);
            String strDtime = df.format(cal.getTime());
            ICommand command = CommandCreator.getInstance().createCommand("STOSlotBatchUpdate", strDtime);
            SQLCommandExecutor.getInstance().executeCmd(command);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public HashMap<String, String> getMapPacketSlot() {
        return this.mapPacketSlot;
    }

    public void setMapPacketSlot(HashMap<String, String> mapPacketSlot) {
        this.mapPacketSlot = mapPacketSlot;
    }

    public String getUpperCase(String strVal) {
        if (strVal == null) {
            return strVal;
        }
        strVal = strVal.toUpperCase();
        return strVal;
    }

    public void InitLastPackOffTime() {
        this.LastPacketOffTime = new Date().getTime();
    }

    public HashMap<String, Integer> getPlatStatics() {
        return this.platStatics;
    }

    public void setPlatStatics(HashMap<String, Integer> platStatics) {
        this.platStatics = platStatics;
    }

    public String getPackCodeBySlot(String strPackList, String strDroppedSlot) {
        String strRes = "none";
        try {
            String[] arrPackList;
            if (strPackList == null) {
                return strRes;
            }
            for (String packslot : arrPackList = strPackList.split(",")) {
                String[] arrPackSlot = packslot.split("=");
                if (arrPackSlot.length <= 1 || !arrPackSlot[0].equalsIgnoreCase(strDroppedSlot)) continue;
                strRes = arrPackSlot[1];
                break;
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "getPackCodeBySlot -- Exception : " + ex, 2));
        }
        return strRes;
    }

    public String getNextStaCodeBySlot(SortInfo sortInfo, int droppedSlot) {
        String strRes = "none";
        try {
            if (sortInfo == null) {
                return strRes;
            }
            for (int i = 0; i < sortInfo.getSortPlanList().size(); ++i) {
                int sortPlanSlot = sortInfo.getSortPlanList().get(i).getFactualSlot();
                if (sortPlanSlot != droppedSlot) continue;
                strRes = sortInfo.getSortPlanList().get(i).getNextStaCode();
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "getNestStaCodeBySlot -- Exception : " + ex, 2));
        }
        return strRes;
    }

    public Boolean canSlotPack(String strModel, SortInfo sortInfo, int slot) {
        Boolean res = false;
        try {
            if (strModel.equalsIgnoreCase("departure")) {
                res = true;
            } else {
                for (int i = 0; i < sortInfo.getSortPlanList().size(); ++i) {
                    int slotCanPack;
                    SortPlanItem sortPlanItem = sortInfo.getSortPlanList().get(i);
                    if (slot != sortPlanItem.getFactualSlot() || (slotCanPack = sortPlanItem.getSlotPack()) <= 0) continue;
                    res = true;
                }
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Sto isSlotCanPack Error -- Exception : " + ex, 2));
        }
        return res;
    }

    public ConcurrentHashMap<String, String> getStoSortPlanDIntercept() {
        return this.stoSortPlanDIntercept;
    }

    public void setStoSortPlanDIntercept(ConcurrentHashMap<String, String> stoSortPlanDIntercept) {
        this.stoSortPlanDIntercept = stoSortPlanDIntercept;
    }

    public String getStoPattern() {
        return this.stoPattern;
    }

    public void setStoPattern(String stoPattern) {
        this.stoPattern = stoPattern;
    }

    public HashMap<String, String> getBarcodeIntercept() {
        return this.barcodeIntercept;
    }

    public void setBarcodeIntercept(HashMap<String, String> barcodeIntercept) {
        this.barcodeIntercept = barcodeIntercept;
    }

    private static class SlotManagerHolder {
        private static final STOSlotManager INSTANCE = new STOSlotManager();

        private SlotManagerHolder() {
        }
    }
}

