/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.sto;

import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.controllers.ISlotUnlockController;
import com.simba.server.netclient.DefaultClientManager;
import org.apache.log4j.Logger;

public class STOSlotUnlockController
implements ISlotUnlockController {
    private static final Logger logger = Logger.getLogger(STOSlotUnlockController.class);

    @Override
    public void onSlotUnlockMessage(SlotInfo slotInfo) {
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "\u89e3\u9501\u6d88\u606f \u683c\u53e3 " + slotInfo.getSlotId(), 1));
        String packCode = "";
        slotInfo.setMailCount(0);
        int stoLockStatus = 1;
        this.handleSlotMsgToMonitor(stoLockStatus, slotInfo);
    }

    private void handleSlotMsgToMonitor(int lockStatus, SlotInfo slotInfo) {
        try {
            String strMsgContent = SorterProtocolCreator.getInstance().createSlotStatusMsg(lockStatus, slotInfo);
            byte[] content = strMsgContent.getBytes();
            DefaultClientManager.getInstance().sendUploadMsgToStoClient(content);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleSlotMsgToMonitor Error -- Exception : " + ex, 2));
        }
    }
}

