/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.sto;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.controllers.ISlotPackController;
import com.simba.server.controllers.sto.STOCommonParams;
import com.simba.server.controllers.sto.data.STOSlotManager;
import com.simba.server.netclient.DefaultClientManager;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class STOSlotPackController
implements ISlotPackController {
    private static final Logger logger = Logger.getLogger(STOSlotPackController.class);

    @Override
    public void onSlotPackMessage(SlotInfo slotInfo) {
        if (slotInfo == null) {
            return;
        }
        String packCode = slotInfo.getPackCode();
        if (packCode == null || packCode.length() < 10) {
            return;
        }
        boolean isArriSlotPack = false;
        if (STOCommonParams.getInstance().getStoMode().contains("arr") && slotInfo.getIsArriveSlotPack() > 0) {
            isArriSlotPack = true;
        }
        int stoLockStatus = 0;
        long curTime = SorterProtocolCreator.getInstance().createCurrentTimeStamp().getTime();
        slotInfo.setOpID(curTime);
        this.handleSlotMsgToMonitor(stoLockStatus, slotInfo);
        slotInfo.setMailCount(0);
        slotInfo.setTotalWeight(0.0);
        if (STOCommonParams.getInstance().getStoMode().contains("dep") || isArriSlotPack) {
            JSONObject dataObj = slotInfo.getRequestObj();
            packCode = dataObj.getString("packetCode");
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "\u9501\u683c\u6d88\u606f \u683c\u53e3 " + slotInfo.getSlotId() + " \u5305\u724c " + packCode, 1));
            this.updateStoPacketSlotStatus(packCode);
            String strSlot = slotInfo.getSlotId();
            dataObj.putOpt("packetCode", "unbind");
            slotInfo.setRequestObj(dataObj);
            STOSlotManager.getInstance().getMapBindPacket().put(strSlot, "unbind");
        } else {
            slotInfo.setPackCode(SlotManager.getInstance().createSlotBindUUID());
        }
    }

    private void handleSlotMsgToMonitor(int lockStatus, SlotInfo slotInfo) {
        try {
            String strMsgContent = SorterProtocolCreator.getInstance().createSlotStatusMsg(lockStatus, slotInfo);
            byte[] content = strMsgContent.getBytes();
            DefaultClientManager.getInstance().sendUploadMsgToStoClient(content);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleSlotMsgToMonitor Error -- Exception : " + ex, 2));
        }
    }

    private void updateStoPacketSlotStatus(String strPackCode) {
        ICommand command = CommandCreator.getInstance().createCommand("STOSlotPackUpdate", strPackCode);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }
}

