/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.sto;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.controllers.ISlotBindController;
import com.simba.server.controllers.sto.data.STOSlotManager;
import com.simba.server.netclient.DefaultClientManager;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class STOSlotBindController
implements ISlotBindController {
    private static final Logger logger = Logger.getLogger(STOSlotBindController.class);

    @Override
    public void onSlotBindMessage(SlotInfo slotInfo) {
        try {
            if (slotInfo == null) {
                return;
            }
            JSONObject dataObj = slotInfo.getRequestObj();
            String slotCode = dataObj.getString("slotCode");
            slotCode = Integer.toString(Integer.parseInt(slotCode));
            String packetCode = dataObj.getString("packetCode");
            if (packetCode.length() >= 18) {
                packetCode = packetCode.substring(0, 13);
            }
            dataObj.putOpt("packetCode", packetCode);
            slotInfo.setPackCode(packetCode);
            slotInfo.setRequestObj(dataObj);
            ICommand command = CommandCreator.getInstance().createCommand("STOSlotStatusUpdate", slotCode);
            Boolean res = SQLCommandExecutor.getInstance().executeCmd(command);
            if (res.booleanValue()) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "\u81ea\u52a8\u66f4\u65b0 \u683c\u53e3 " + slotCode + " \u72b6\u6001 ", 1));
            }
            this.restoreStoPacketSlotStatus(slotInfo);
            STOSlotManager.getInstance().getMapBindPacket().put(slotCode, packetCode);
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "\u7ed1\u5b9a\u6d88\u606f \u683c\u53e3 " + slotCode + " \u5305\u724c " + packetCode, 1));
            this.handlePackageMsgToMonitor(packetCode, Integer.parseInt(slotCode));
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle onSlotBindMessage Error -- Exception : " + ex, 2));
        }
    }

    private void handlePackageMsgToMonitor(String packetCode, int slotID) {
        try {
            String strMsgContent = SorterProtocolCreator.getInstance().createPackageMsg(packetCode, slotID);
            byte[] content = strMsgContent.getBytes();
            DefaultClientManager.getInstance().sendUploadMsgToStoClient(content);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handlePackageMsgToMonitor Error -- Exception : " + ex, 2));
        }
    }

    private void updateStoPacketSlotStatus(String strPackCode) {
        ICommand command = CommandCreator.getInstance().createCommand("STOSlotPackUpdate", strPackCode);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private void restoreStoPacketSlotStatus(SlotInfo slotInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("STOSlotBind", slotInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }
}

