/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.sto;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.ServerParam;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.PlatInstance;
import com.simba.server.components.PlatInstanceManager;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.PlcInfo;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.IScannedController;
import com.simba.server.controllers.sto.STOCommonParams;
import com.simba.server.controllers.sto.data.STOSlotManager;
import com.simba.server.netclient.DefaultClientManager;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class STOScannedController
implements IScannedController {
    private static final Logger logger = Logger.getLogger(STOScannedController.class);

    @Override
    public void onScannedMessage(SortInfo sortInfo) {
        if (STOCommonParams.getInstance().isRequestWebSlot()) {
            ICommand command = CommandCreator.getInstance().createCommand("WebSortPlanCmd", sortInfo);
            Boolean ret = WebCommandExecutor.getInstance().executeCmd(command);
            this.handleRookieChuteResponse(sortInfo);
        } else {
            this.requestStoSortInfo(sortInfo);
        }
        if (STOCommonParams.getInstance().isHavaMonitorService()) {
            this.handleSendScanMsgToMonitor(sortInfo);
        }
    }

    private void handleSendScanMsgToMonitor(SortInfo sortInfo) {
        try {
            String strMsgContent = SorterProtocolCreator.getInstance().createScanMsg(sortInfo);
            byte[] content = strMsgContent.getBytes();
            DefaultClientManager.getInstance().sendUploadMsgToStoClient(content);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleSendScanMsgToMonitor Error -- Exception : " + ex, 2));
        }
    }

    private void handleArrivalSortInfoRookie(SortInfo sortInfo) {
        try {
            JSONObject dataObj = sortInfo.getDataObj();
            dataObj.put("stoMode", "arrival");
            if (sortInfo.getServerErrorCode() == 0) {
                ICommand command = CommandCreator.getInstance().createCommand("STONotSorted", sortInfo.getBarcode());
                boolean res = SQLCommandExecutor.getInstance().executeCmd(command);
                if (!res) {
                    sortInfo.setInterceptFlag(1);
                    sortInfo.setRookieServerError(5);
                }
            }
            if (sortInfo.getInterceptFlag() == 1) {
                this.handleInterceptSortInfo(sortInfo);
            } else if (sortInfo.getServerErrorCode() == 3) {
                this.handleInterceptSortInfo(sortInfo);
            } else if (sortInfo.getServerErrorCode() == 1) {
                if (STOCommonParams.getInstance().getIsUseVC() > 0) {
                    sortInfo.setIsNeedVideoCoding(1);
                    sortInfo.getSlotsList().clear();
                }
                this.handleNoInfoSortInfo(sortInfo);
            } else if (sortInfo.getServerErrorCode() == 2) {
                this.handleNoSortPlanSortInfo(sortInfo);
            } else if (sortInfo.getServerErrorCode() == 0) {
                this.handleNormalSortInfo(sortInfo);
            }
            this.sendStoSortInfoToClient(sortInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleArrivalSortInfoRookieError -- Exception : " + ex, 2));
        }
    }

    private void handleArrivalSortInfo(SortInfo sortInfo) {
        try {
            JSONObject dataObj = sortInfo.getDataObj();
            dataObj.put("stoMode", "arrival");
            ICommand command = CommandCreator.getInstance().createCommand("STORemoteSortInfoA", sortInfo);
            Boolean res = SlotManager.getInstance().stoRemoteDbSQLCommandExecutor.executeCmd(command);
            if (res.booleanValue()) {
                command = CommandCreator.getInstance().createCommand("STONotSorted", sortInfo.getBarcode());
                res = SQLCommandExecutor.getInstance().executeCmd(command);
                if (!res.booleanValue()) {
                    sortInfo.setInterceptFlag(1);
                    sortInfo.setRookieServerError(5);
                }
                if (sortInfo.getInterceptFlag() == 0) {
                    sortInfo.setIsNeedVideoCoding(0);
                    command = CommandCreator.getInstance().createCommand("STOSortPlanANew", sortInfo);
                    res = SQLCommandExecutor.getInstance().executeCmd(command);
                    if (res.booleanValue()) {
                        this.handleNormalSortInfo(sortInfo);
                    } else {
                        this.handleNoSortPlanSortInfo(sortInfo);
                    }
                } else {
                    this.handleInterceptSortInfo(sortInfo);
                }
            } else {
                if (STOCommonParams.getInstance().getIsUseVC() > 0) {
                    sortInfo.setIsNeedVideoCoding(1);
                    sortInfo.getSlotsList().clear();
                }
                this.handleNoInfoSortInfo(sortInfo);
            }
            this.sendStoSortInfoToClient(sortInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Sto Arrival Sort Info Error -- Exception : " + ex, 2));
        }
    }

    private void handleDepartureSortInfoRookie(SortInfo sortInfo) {
        try {
            JSONObject dataObj = sortInfo.getDataObj();
            dataObj.put("stoMode", "departure");
            boolean res = false;
            if (sortInfo.getServerErrorCode() == 0) {
                ICommand command = CommandCreator.getInstance().createCommand("STOSortPlanDIntercept", sortInfo);
                res = SQLCommandExecutor.getInstance().executeCmd(command);
                if (res) {
                    sortInfo.setRookieServerError(5);
                    sortInfo.setInterceptFlag(1);
                }
                sortInfo.setIsNeedVideoCoding(0);
            }
            if (sortInfo.getInterceptFlag() == 1) {
                this.handleInterceptSortInfo(sortInfo);
            } else if (sortInfo.getServerErrorCode() == 1) {
                if (STOCommonParams.getInstance().getIsUseVC() > 0) {
                    sortInfo.setIsNeedVideoCoding(1);
                    sortInfo.getSlotsList().clear();
                }
                this.handleNoInfoSortInfo(sortInfo);
            } else if (sortInfo.getServerErrorCode() == 2) {
                this.handleNoSortPlanSortInfo(sortInfo);
            } else if (sortInfo.getServerErrorCode() == 0) {
                this.handleNormalSortInfo(sortInfo);
            }
            this.sendStoSortInfoToClient(sortInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleDepartureSortInfoRookie -- Exception : " + ex, 2));
        }
    }

    private void handleDepartureSortInfo(SortInfo sortInfo) {
        try {
            JSONObject dataObj = sortInfo.getDataObj();
            dataObj.put("stoMode", "departure");
            ICommand command = CommandCreator.getInstance().createCommand("STORemoteSortInfoD", sortInfo);
            Boolean res = SlotManager.getInstance().stoRemoteDbSQLCommandExecutor.executeCmd(command);
            if (res.booleanValue()) {
                command = CommandCreator.getInstance().createCommand("STOSortPlanDIntercept", sortInfo);
                res = SQLCommandExecutor.getInstance().executeCmd(command);
                if (res.booleanValue()) {
                    sortInfo.setRookieServerError(5);
                    sortInfo.setInterceptFlag(1);
                }
                sortInfo.setIsNeedVideoCoding(0);
                if (sortInfo.getInterceptFlag() == 0) {
                    command = CommandCreator.getInstance().createCommand("STOSortPlanDNew", sortInfo);
                    res = SQLCommandExecutor.getInstance().executeCmd(command);
                    if (res.booleanValue()) {
                        this.handleNormalSortInfo(sortInfo);
                    } else {
                        this.handleNoSortPlanSortInfo(sortInfo);
                    }
                } else {
                    this.handleInterceptSortInfo(sortInfo);
                }
            } else {
                if (STOCommonParams.getInstance().getIsUseVC() > 0) {
                    sortInfo.setIsNeedVideoCoding(1);
                    sortInfo.getSlotsList().clear();
                }
                this.handleNoInfoSortInfo(sortInfo);
            }
            this.sendStoSortInfoToClient(sortInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Sto Depatures Sort Info Error -- Exception : " + ex, 2));
        }
    }

    private void handleNormalSortInfo(SortInfo sortInfo) {
        try {
            List<Integer> slots = sortInfo.getSlotsList();
            boolean isAllSlotLock = true;
            LinkedList<Integer> slotsLocked = new LinkedList<Integer>();
            LinkedList<Integer> slotsUnbinded = new LinkedList<Integer>();
            LinkedList<Integer> slotsValid = new LinkedList<Integer>();
            int unBindCount = 0;
            int slotsCount = slots.size();
            sortInfo.setDroppedErrorCode(0);
            sortInfo.setServerErrorCode(0);
            JSONObject dataObject = sortInfo.getDataObj();
            String strModel = dataObject.getString("stoMode");
            if (strModel.equalsIgnoreCase("departure") || strModel.equalsIgnoreCase("arrival")) {
                String strPackage;
                for (Integer Slot : slots) {
                    boolean isSlotLock = true;
                    if (!SlotManager.getInstance().droppedSlotIsLockoverTime(Slot).booleanValue()) {
                        isAllSlotLock = false;
                        isSlotLock = false;
                    } else if (!slotsLocked.contains(Slot)) {
                        slotsLocked.add(Slot);
                    }
                    if (STOSlotManager.getInstance().getMapBindPacket().containsKey(String.valueOf(Slot)) && STOSlotManager.getInstance().canSlotPack(strModel, sortInfo, Slot).booleanValue()) {
                        strPackage = STOSlotManager.getInstance().getMapBindPacket().get(String.valueOf(Slot));
                        if (strPackage.contains("unbind")) {
                            if (!slotsUnbinded.contains(Slot)) {
                                slotsUnbinded.add(Slot);
                            }
                            ++unBindCount;
                            continue;
                        }
                        if (isSlotLock) continue;
                        slotsValid.add(Slot);
                        continue;
                    }
                    if (STOSlotManager.getInstance().canSlotPack(strModel, sortInfo, Slot).booleanValue()) {
                        if (!slotsUnbinded.contains(Slot)) {
                            slotsUnbinded.add(Slot);
                        }
                        ++unBindCount;
                        continue;
                    }
                    slotsValid.add(Slot);
                }
                if (isAllSlotLock) {
                    dataObject.put("msg", "lock");
                    dataObject.put("exceptionCode", "7");
                    if (slotsUnbinded.size() > 0) {
                        sortInfo.getSlotsList().clear();
                        for (Integer lockedSlot : slotsLocked) {
                            sortInfo.getSlotsList().add(lockedSlot);
                        }
                    }
                } else if (unBindCount == slotsCount) {
                    dataObject.put("msg", "unbind");
                    dataObject.put("exceptionCode", "6");
                    if (slotsUnbinded.size() > 0) {
                        sortInfo.getSlotsList().clear();
                        String unBindedSlots = "";
                        for (Integer unbinedSlot : slotsUnbinded) {
                            sortInfo.getSlotsList().add(unbinedSlot);
                            unBindedSlots = unBindedSlots + unbinedSlot.toString() + " ";
                        }
                        unBindedSlots = unBindedSlots.trim();
                        this.sendUnbindMessageToClien(unBindedSlots);
                    }
                } else {
                    String strPackageList = "";
                    sortInfo.getSlotsList().clear();
                    for (Integer Slot : slotsValid) {
                        if (STOSlotManager.getInstance().getMapBindPacket().containsKey(String.valueOf(Slot))) {
                            strPackage = STOSlotManager.getInstance().getMapBindPacket().get(String.valueOf(Slot));
                            strPackageList = strPackageList + String.valueOf(Slot) + "=" + strPackage + ",";
                            sortInfo.getSlotsList().add(Slot);
                            continue;
                        }
                        if (!strModel.equalsIgnoreCase("arrival")) continue;
                        String slotKey = String.valueOf(Slot);
                        SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotKey);
                        if (slotInfo.getIsArriveSlotPack() >= 1) continue;
                        sortInfo.getSlotsList().add(Slot);
                    }
                    if (strPackageList.endsWith(",")) {
                        strPackageList = strPackageList.substring(0, strPackageList.length() - 1);
                        dataObject.put("sto-pckcode", strPackageList);
                        sortInfo.setDataObj(dataObject);
                        sortInfo.setPackCode(strPackageList);
                    }
                    this.sendStoSortInfoToPLC(sortInfo);
                }
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Sto handleNormalSortInfo Error -- Exception : " + ex, 2));
        }
    }

    private int getRandomSlot(List<Integer> slotsValid) {
        int validSlot = 0;
        try {
            if (slotsValid != null && slotsValid.size() > 0) {
                int index = (int)(Math.random() * (double)slotsValid.size());
                validSlot = slotsValid.get(index);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "getRandomSlot Error -- Exception : " + ex, 2));
        }
        return validSlot;
    }

    private void sendUnbindMessageToClien(String strSlot) {
        try {
            Channel[] channelList;
            JSONObject dataObject = new JSONObject();
            dataObject.put("ServiceName", "unBindSlot");
            dataObject.put("slot", strSlot);
            dataObject.put("msg", "unbind");
            for (Channel channel : channelList = JsonChannelManager.getInstance().getChannelList()) {
                JsonChannelManager.getInstance().commitResponse(channel, dataObject.toString().getBytes(), false);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "sendUnbindMessageToClien Error -- Exception : " + ex, 2));
        }
    }

    private void handleNoInfoSortInfo(SortInfo sortInfo) {
        try {
            sortInfo.setServerErrorCode(1);
            if (STOCommonParams.getInstance().getIsUseVC() == 0) {
                List<String> noInfoSlots = SlotManager.getInstance().getNoInfoTrashSlots();
                sortInfo.getSlotsList().clear();
                for (String trashSlot : noInfoSlots) {
                    sortInfo.getSlotsList().add(Integer.parseInt(trashSlot));
                }
            }
            if (ServerParam.TRASH_STOP != 1) {
                this.sendStoSortInfoToPLC(sortInfo);
            }
            JSONObject dataObj = sortInfo.getDataObj();
            dataObj.put("msg", "trashSlot");
            dataObj.put("exceptionCode", "1");
            sortInfo.setDataObj(dataObj);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Sto handleNoInfoSortInfo Error -- Exception : " + ex, 2));
        }
    }

    private void handleNoSortPlanSortInfo(SortInfo sortInfo) {
        try {
            sortInfo.setServerErrorCode(2);
            List<String> noPlanSlots = SlotManager.getInstance().getNoPlanTrashSlots();
            sortInfo.getSlotsList().clear();
            for (String trashSlot : noPlanSlots) {
                sortInfo.getSlotsList().add(Integer.parseInt(trashSlot));
            }
            if (ServerParam.TRASH_STOP != 1) {
                this.sendStoSortInfoToPLC(sortInfo);
            }
            JSONObject dataObj = sortInfo.getDataObj();
            dataObj.put("msg", "trashSlot");
            dataObj.put("exceptionCode", "2");
            sortInfo.setDataObj(dataObj);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Sto handleNoSortPlanSortInfo Error -- Exception : " + ex, 2));
        }
    }

    private void handleInterceptSortInfo(SortInfo sortInfo) {
        try {
            if (sortInfo.getServerErrorCode() == 0) {
                sortInfo.setServerErrorCode(5);
            }
            List<String> interceptSlots = SlotManager.getInstance().getInterCeptSlots();
            sortInfo.getSlotsList().clear();
            for (String trashSlot : interceptSlots) {
                sortInfo.getSlotsList().add(Integer.parseInt(trashSlot));
            }
            this.sendStoSortInfoToPLC(sortInfo);
            JSONObject dataObj = sortInfo.getDataObj();
            dataObj.put("msg", "copy");
            dataObj.put("exceptionCode", "5");
            sortInfo.setDataObj(dataObj);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Sto handleInterceptSortInfo Error -- Exception : " + ex, 2));
        }
    }

    private void handleRookieChuteResponse(SortInfo sortInfo) {
        try {
            String currentMode = STOCommonParams.getInstance().getStoMode();
            if (currentMode.equals("arrival")) {
                this.handleArrivalSortInfoRookie(sortInfo);
            } else if (currentMode.equals("departure")) {
                this.handleDepartureSortInfoRookie(sortInfo);
            }
            this.restoreScanInfo(sortInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Sto Handle Sort Info Error : " + sortInfo.getBarcode(), 3));
        }
    }

    private void requestStoSortInfo(SortInfo sortInfo) {
        try {
            String currentMode = STOCommonParams.getInstance().getStoMode();
            if (currentMode.equals("arrival")) {
                this.handleArrivalSortInfo(sortInfo);
            } else if (currentMode.equals("departure")) {
                this.handleDepartureSortInfo(sortInfo);
            }
            this.restoreScanInfo(sortInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Sto Handle Sort Info Error : " + sortInfo.getBarcode(), 3));
        }
    }

    private void restoreScanInfo(SortInfo sortInfo) {
        try {
            ICommand command = CommandCreator.getInstance().createCommand("STOScanned", sortInfo);
            SQLCommandExecutor.getInstance().executeCmd(command);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "restoreScanInfo Error : " + sortInfo.getBarcode(), 3));
        }
    }

    private void sendStoSortInfoToPLC(SortInfo sortInfo) {
        Channel[] clients;
        byte[] replyBuffer = SorterProtocolCreator.getInstance().createSortInfoWithPlat(sortInfo);
        PlcInfo plcInfo = SlotManager.getInstance().getPlcInfoByPlatID(Integer.parseInt(sortInfo.getPlatId()));
        for (Channel client : clients = FrameChannelManager.getInstance().getChannelList()) {
            if (!client.getRemoteAddress().toString().contains(plcInfo.getPlcAddr())) continue;
            FrameChannelManager.getInstance().commitResponse(client, replyBuffer, false);
        }
        sortInfo.setLayer(plcInfo.getLayer());
    }

    private void sendStoSortInfoToClient(SortInfo sortInfo) {
        String platId = sortInfo.getPlatId();
        PlatInstance plat = PlatInstanceManager.getInstance().getPlatById(platId);
        String strResponse = this.getScanResponse(sortInfo);
        if (plat != null) {
            JsonChannelManager.getInstance().commitResponse(plat.getPlatClient(), strResponse.getBytes(), false);
        }
    }

    private String getScanResponse(SortInfo sortInfo) {
        JSONObject sortInfoObj = new JSONObject();
        sortInfoObj.put("ServiceName", "SortResult");
        String slots = "";
        if (sortInfo.getSlotsList().size() > 0) {
            for (int slot : sortInfo.getSlotsList()) {
                slots = slots + String.valueOf(slot) + "|";
            }
        }
        JSONObject dataObj = sortInfo.getDataObj();
        String strMsg = "";
        if (!dataObj.isNull("msg")) {
            strMsg = dataObj.get("msg").toString();
        }
        String strExceptionCode = "0";
        if (!dataObj.isNull("exceptionCode")) {
            strExceptionCode = dataObj.get("exceptionCode").toString();
        }
        if (!slots.equalsIgnoreCase("")) {
            sortInfoObj.put("factualSlot", slots.substring(0, slots.length() - 1));
        } else {
            sortInfoObj.put("factualSlot", "0");
        }
        sortInfoObj.put("packageCode", sortInfo.getPackCode());
        sortInfoObj.put("barcode", sortInfo.getBarcode());
        sortInfoObj.put("weight", sortInfo.getWeight());
        sortInfoObj.put("exceptionCode", strExceptionCode);
        sortInfoObj.put("isNeedVideo", sortInfo.getIsNeedVideoCoding());
        sortInfoObj.put("sortModel", "sto-" + dataObj.get("stoMode").toString());
        sortInfoObj.put("msg", strMsg);
        return sortInfoObj.toString();
    }

    private boolean isBarcoedNotSorted(String strBarcode) {
        boolean res = true;
        try {
            ICommand command = CommandCreator.getInstance().createCommand("STONotSorted", strBarcode);
            res = SQLCommandExecutor.getInstance().executeCmd(command);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "isBarcoedSorted Error : " + strBarcode, 2));
        }
        return res;
    }
}

