/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.sto;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.components.data.SortPlanItem;
import com.simba.server.controllers.IPacketOffController;
import com.simba.server.controllers.sto.STOCommonParams;
import com.simba.server.controllers.sto.data.STOSlotManager;
import com.simba.server.netclient.DefaultClientManager;
import java.util.Date;
import org.apache.log4j.Logger;

public class STOPacketOffController
implements IPacketOffController {
    private static final Logger logger = Logger.getLogger(STOPacketOffController.class);

    @Override
    public void onPacketOffMessage(SortInfo sortInfo) {
        try {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle onPacketOffMessage : ", 3));
            STOSlotManager.getInstance().LastPacketOffTime = new Date().getTime();
            this.handleNestStaCode(sortInfo);
            this.restoreStoPacketOffInfo(sortInfo);
            this.restoreStoPacketResultInfo(sortInfo);
            this.restoreStpPacketOffHistoryInfo(sortInfo);
            if (STOCommonParams.getInstance().isHavaMonitorService()) {
                this.handleSendMsgToMonitor(sortInfo);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Sto Packet Off Message In STOPacketOffController Handler Error -- Exception : " + ex, 2));
        }
    }

    private void handleSendMsgToMonitor(SortInfo sortInfo) {
        try {
            int droppedSlotId = sortInfo.getDroppedSlotId();
            String slotId = String.valueOf(droppedSlotId);
            SlotInfo slotInfo = SlotManager.getInstance().getSlotInfo(slotId);
            if (slotInfo == null) {
                return;
            }
            if (sortInfo.getServerErrorCode() != 0) {
                return;
            }
            double totalWeight = slotInfo.getTotalWeight();
            String weight = sortInfo.getWeight();
            double dWeight = 0.0;
            try {
                dWeight = Double.parseDouble(weight);
            }
            catch (Exception exception) {
                // empty catch block
            }
            slotInfo.setTotalWeight(totalWeight += dWeight);
            String strMsgContent = SorterProtocolCreator.getInstance().createDropMsg(sortInfo);
            byte[] content = strMsgContent.getBytes();
            DefaultClientManager.getInstance().sendUploadMsgToStoClient(content);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleSendMsgToMonitor Error -- Exception : " + ex, 2));
        }
    }

    private void handleNestStaCode(SortInfo sortInfo) {
        try {
            for (int i = 0; i < sortInfo.getSortPlanList().size(); ++i) {
                SortPlanItem sortPlan = sortInfo.getSortPlanList().get(i);
                if (sortInfo.getDroppedSlotId() != sortPlan.getFactualSlot()) continue;
                sortInfo.setSiteCode(sortPlan.getPackName());
                sortInfo.setNextStaCode(sortPlan.getNextStaCode());
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleNestStaCode Error -- Exception : " + ex, 2));
        }
    }

    private void restoreStpPacketOffHistoryInfo(SortInfo sortInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("STOPacketOffHistory", sortInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private void restoreStoPacketResultHistoryInfo(SortInfo sortInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("STOPackResultHistory", sortInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private void restoreStoPacketOffInfo(SortInfo sortInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("STOPacketOff", sortInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private void restoreStoPacketResultInfo(SortInfo sortInfo) {
        ICommand command = CommandCreator.getInstance().createCommand("STOPackResult", sortInfo);
        SQLCommandExecutor.getInstance().executeCmd(command);
    }

    private void addPlatStatic(SortInfo sortInfo) {
        try {
            String platID = sortInfo.getPlatId();
            if (!STOSlotManager.getInstance().getPlatStatics().containsKey(platID)) {
                STOSlotManager.getInstance().getPlatStatics().put(platID, 1);
            } else {
                int sortNumber = STOSlotManager.getInstance().getPlatStatics().get(platID);
                STOSlotManager.getInstance().getPlatStatics().put(platID, ++sortNumber);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "addPlatStatic Error -- Exception : " + ex, 2));
        }
    }
}

