/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.controllers.sto;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SlotManager;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.IBarcodeQueryController;
import com.simba.server.controllers.sto.STOCommonParams;
import java.util.List;
import org.apache.log4j.Logger;

public class STOBarcodeQueryController
implements IBarcodeQueryController {
    private static final Logger logger = Logger.getLogger(STOBarcodeQueryController.class);

    @Override
    public void onBarcodeQueryMessage(SortInfo sortInfo) {
        try {
            if (sortInfo == null) {
                return;
            }
            Boolean res = false;
            ICommand command = CommandCreator.getInstance().createCommand("STOSortResultHistory", sortInfo);
            res = SQLCommandExecutor.getInstance().executeCmd(command);
            String currentMode = STOCommonParams.getInstance().getStoMode();
            if (currentMode.equals("arrival")) {
                sortInfo.setSortInfoMode("arrival");
                command = CommandCreator.getInstance().createCommand("STOSortInfoA", sortInfo);
                res = SQLCommandExecutor.getInstance().executeCmd(command);
                if (!res.booleanValue() && (res = SlotManager.getInstance().stoRemoteDbSQLCommandExecutor.executeCmd(command = CommandCreator.getInstance().createCommand("STORemoteSortInfoA", sortInfo))).booleanValue()) {
                    LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "can't find barcode in simba db,but finded in remoteDb:" + sortInfo.getBarcode(), 1));
                }
            } else if (currentMode.equals("departure")) {
                sortInfo.setSortInfoMode("departure");
                command = CommandCreator.getInstance().createCommand("STOSortInfoD", sortInfo);
                res = SQLCommandExecutor.getInstance().executeCmd(command);
                if (!res.booleanValue() && (res = SlotManager.getInstance().stoRemoteDbSQLCommandExecutor.executeCmd(command = CommandCreator.getInstance().createCommand("STORemoteSortInfoD", sortInfo))).booleanValue()) {
                    LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "can't find barcode in simba db,but finded in remoteDb:" + sortInfo.getBarcode(), 1));
                }
            }
            if (!res.booleanValue()) {
                this.handleNoInfoSortInfo(sortInfo);
                return;
            }
            if (currentMode.equals("arrival")) {
                command = CommandCreator.getInstance().createCommand("STOSortPlanANew", sortInfo);
                res = SQLCommandExecutor.getInstance().executeCmd(command);
                if (!res.booleanValue()) {
                    this.handleNoSortPlanSortInfo(sortInfo);
                } else {
                    sortInfo.setServerErrorCode(0);
                }
            } else if (currentMode.equals("departure")) {
                command = CommandCreator.getInstance().createCommand("STOSortPlanDIntercept", sortInfo);
                res = SQLCommandExecutor.getInstance().executeCmd(command);
                if (res.booleanValue()) {
                    this.handleInterceptSortInfo(sortInfo);
                    return;
                }
                command = CommandCreator.getInstance().createCommand("STOSortPlanDNew", sortInfo);
                res = SQLCommandExecutor.getInstance().executeCmd(command);
                if (!res.booleanValue()) {
                    this.handleNoSortPlanSortInfo(sortInfo);
                } else {
                    sortInfo.setDroppedErrorCode(0);
                }
            }
            return;
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle onBarcodeQueryMessage Error -- Exception : " + ex, 2));
            return;
        }
    }

    private void handleInterceptSortInfo(SortInfo sortInfo) {
        try {
            sortInfo.setServerErrorCode(5);
            List<String> interceptSlots = SlotManager.getInstance().getInterCeptSlots();
            for (String trashSlot : interceptSlots) {
                sortInfo.getSlotsList().add(Integer.parseInt(trashSlot));
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Sto handleInterceptSortInfo Error -- Exception : " + ex, 2));
        }
    }

    private void handleNoInfoSortInfo(SortInfo sortInfo) {
        try {
            sortInfo.setServerErrorCode(1);
            List<String> noInfoSlots = SlotManager.getInstance().getNoInfoTrashSlots();
            for (String trashSlot : noInfoSlots) {
                sortInfo.getSlotsList().add(Integer.parseInt(trashSlot));
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Sto handleNoInfoSortInfo Error -- Exception : " + ex, 2));
        }
    }

    private void handleNoSortPlanSortInfo(SortInfo sortInfo) {
        try {
            sortInfo.setServerErrorCode(2);
            List<String> noPlanSlots = SlotManager.getInstance().getNoPlanTrashSlots();
            for (String trashSlot : noPlanSlots) {
                sortInfo.getSlotsList().add(Integer.parseInt(trashSlot));
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Sto handleNoSortPlanSortInfo Error -- Exception : " + ex, 2));
        }
    }
}

