/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components.task;

import com.simba.common.command.ICommand;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import org.apache.log4j.Logger;

public class SynTimeTask
extends Thread {
    private static final Logger logger = Logger.getLogger(SynTimeTask.class);
    private static final int REQUEST_INTERVAL = 21600000;

    public static SynTimeTask getInstance() {
        return SynTimeTaskHolder.INSTANCE;
    }

    public SynTimeTask() {
        this.setName("SynTime-Task");
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.doHandleSynTime();
                Thread.sleep(21600000L);
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch an exception [" + ex.getMessage() + "]", 2));
            }
        }
    }

    private void doHandleSynTime() {
        ICommand command = CommandCreator.getInstance().createCommand("WebSynTime", null);
        Boolean ret = WebCommandExecutor.getInstance().executeCmd(command);
    }

    private static class SynTimeTaskHolder {
        private static final SynTimeTask INSTANCE = new SynTimeTask();

        private SynTimeTaskHolder() {
        }
    }
}

