/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components.task;

import com.simba.common.command.ICommand;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.PlatInstanceManager;
import com.simba.server.components.SlotManager;
import com.simba.server.components.data.StaticInfo;
import com.simba.server.controllers.sto.STOCommonParams;
import com.simba.server.controllers.sto.data.STOSlotManager;
import java.net.InetAddress;
import java.net.NetworkInterface;
import org.apache.log4j.Logger;

public class SortResultStaticTask
extends Thread {
    private static final Logger logger = Logger.getLogger(SortResultStaticTask.class);
    private static final int REQUEST_INTERVAL = 600000;
    private static String strMacAddr = "";

    public static SortResultStaticTask getInstance() {
        return SortResultStaticTaskHolder.INSTANCE;
    }

    public SortResultStaticTask() {
        this.setName("Sort-Result-Static-Task");
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.doHandleResetIntercept();
                Thread.sleep(600000L);
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch an exception [" + ex.getMessage() + "]", 2));
            }
        }
    }

    private void doHandleResetIntercept() {
        SlotManager.getInstance().initTrashSlots();
        STOSlotManager.getInstance().resetStoIntercept();
    }

    private void doHandlePlatStatic() {
        try {
            if (STOCommonParams.getInstance().getStoServerStaticHost().isEmpty()) {
                return;
            }
            int paltNumbers = PlatInstanceManager.getInstance().getPlatsNumber();
            for (int i = 1; i <= paltNumbers; ++i) {
                String paltID = String.valueOf(i);
                if (!STOSlotManager.getInstance().getPlatStatics().containsKey(paltID)) continue;
                int packNumber = STOSlotManager.getInstance().getPlatStatics().get(paltID);
                StaticInfo staticInfo = this.createStaticInfo(Integer.parseInt(paltID), packNumber);
                ICommand command = CommandCreator.getInstance().createCommand("STOStatic", staticInfo);
                Boolean ret = WebCommandExecutor.getInstance().executeCmd(command);
                if (ret.booleanValue()) {
                    STOSlotManager.getInstance().getPlatStatics().put(paltID, 0);
                    continue;
                }
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "upload static data error platid=" + paltID + " number=" + packNumber, 2));
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch an exception [" + ex.getMessage() + "]", 2));
        }
    }

    private StaticInfo createStaticInfo(int platID, int packNumber) {
        StaticInfo staticInfo = new StaticInfo();
        staticInfo.setSiteCode(STOCommonParams.getInstance().getStoSiteCode());
        staticInfo.setSupplierID(STOCommonParams.getInstance().getStoSupplierID());
        if (strMacAddr.equalsIgnoreCase("")) {
            strMacAddr = this.getLocalMac();
        }
        staticInfo.setDeviceID(strMacAddr);
        staticInfo.setDeviceType("1");
        staticInfo.setNumbers(packNumber);
        staticInfo.setPlatID(platID);
        int supplierType = Integer.parseInt(STOCommonParams.getInstance().getStoSupplierType());
        staticInfo.setSupplierType(supplierType);
        return staticInfo;
    }

    private String getLocalMac() {
        String strMacAddr = "";
        try {
            InetAddress ia = InetAddress.getLocalHost();
            byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < mac.length; ++i) {
                int temp;
                String str;
                if (i != 0) {
                    sb.append("-");
                }
                if ((str = Integer.toHexString(temp = mac[i] & 0xFF)).length() == 1) {
                    sb.append("0" + str);
                    continue;
                }
                sb.append(str);
            }
            strMacAddr = sb.toString().toUpperCase();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strMacAddr;
    }

    private static class SortResultStaticTaskHolder {
        private static final SortResultStaticTask INSTANCE = new SortResultStaticTask();

        private SortResultStaticTaskHolder() {
        }
    }
}

