/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components.task;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LogUtil;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SendAlertMessage;
import com.simba.server.controllers.sto.STOCommonParams;
import java.util.Date;
import org.apache.log4j.Logger;

public class DataUploadCheckTask
extends Thread {
    private static final Logger logger = Logger.getLogger(DataUploadCheckTask.class);
    private static final int REQUEST_INTERVAL = 600000;
    private static final int MessageSendedLimit = 5;
    private String Threshold = "200";
    private Long AlertStartDay;
    private Long CurrentAlertDay;
    private int OneDaySeconds = 86400;
    private int MessageSendedCount = 0;
    public int UploadFaildCount = 0;

    public DataUploadCheckTask() {
        this.initParams();
        this.setName("Data-Upload-Check-Task");
    }

    private void initParams() {
        this.CurrentAlertDay = this.AlertStartDay = Long.valueOf(new Date().getTime());
    }

    private void RefreshDateRecord() {
        this.CurrentAlertDay = new Date().getTime();
        Long timeSpan = (this.CurrentAlertDay - this.AlertStartDay) / 1000L;
        if (timeSpan >= (long)this.OneDaySeconds) {
            this.AlertStartDay = this.CurrentAlertDay;
            this.MessageSendedCount = 0;
        }
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.doHandleCheckTask();
                Thread.sleep(600000L);
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch an exception [" + ex.getMessage() + "]", 2));
            }
        }
    }

    private void doHandleCheckTask() {
        try {
            if (this.MessageSendedCount >= 5) {
                this.RefreshDateRecord();
                return;
            }
            String SmsPhoneNumberStr = STOCommonParams.getInstance().getSmsPhoneNumber();
            String[] SmsPhoneNumbers = SmsPhoneNumberStr.split(",");
            String SiteCode = STOCommonParams.getInstance().getSiteName();
            SendAlertMessage sendSms = new SendAlertMessage();
            this.Threshold = STOCommonParams.getInstance().getThreshold();
            this.UploadFaildCount = 0;
            ICommand command = CommandCreator.getInstance().createCommand("DataUploadCheck", this.Threshold);
            Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
            if (ret.booleanValue() && this.UploadFaildCount > Integer.parseInt(STOCommonParams.getInstance().getThreshold())) {
                boolean flag = false;
                for (String number : SmsPhoneNumbers) {
                    String content = this.UploadFaildCount + "\u6761\u6570\u636e\u672a\u4e0a\u4f20";
                    if (sendSms.DoSendMessage(SiteCode, number, content)) {
                        flag = true;
                        LogUtil.LogDebug(logger, content + " send to : " + number);
                        continue;
                    }
                    LogUtil.LogError(logger, content + " failed to send to : " + number);
                }
                if (flag) {
                    ++this.MessageSendedCount;
                }
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "DataUploadCheckTask Catch an exception [" + ex.getMessage() + "]", 2));
        }
    }
}

