/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.data.SorterStatus;
import com.simba.server.controllers.sto.STOCommonParams;
import com.simba.server.controllers.sto.data.STOSlotManager;
import com.simba.server.controllers.yunda.YundaCommonParams;
import com.simba.server.netclient.DefaultClientManager;
import java.util.Date;
import org.apache.log4j.Logger;

public class SorterCommonParams {
    protected static final Logger logger = Logger.getLogger(SorterCommonParams.class);
    private int maxLoopCircles;
    private boolean newThreadEachRequest;
    private String pipeline;
    private boolean simulateMode;
    private int slotNumber;
    private final SorterStatus sorterStatus = new SorterStatus();
    private int turnNumber;

    public static SorterCommonParams getInstance() {
        return SorterParameterHolder.INSTANCE;
    }

    private SorterCommonParams() {
    }

    public int getMaxLoopCircles() {
        return this.maxLoopCircles;
    }

    public String getPipeline() {
        return this.pipeline;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public int getTurnNumber() {
        return this.turnNumber;
    }

    public void init() {
        try {
            this.initCommonParams();
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "SorterCommonParams init catch an exception : " + ex.getMessage(), 2));
        }
    }

    public boolean isNewThreadEachRequest() {
        return this.newThreadEachRequest;
    }

    public boolean isSimulateMode() {
        return this.simulateMode;
    }

    public void setNewThreadEachRequest(boolean newThreadEachRequest) {
        this.newThreadEachRequest = newThreadEachRequest;
    }

    public void setPipeline(String pipeline) {
        this.pipeline = pipeline;
    }

    public void setSimulateMode(boolean simulateMode) {
        this.simulateMode = simulateMode;
    }

    public void setSlotNumber(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    public void setTurnNumber(int turnNumber) {
        this.turnNumber = turnNumber;
    }

    public void UpdateSorterStatus() {
        String currentMode = SortControllerManager.getInstance().getCurrentSortInfoMode();
        if (currentMode.equalsIgnoreCase("STO")) {
            this.sorterStatus.setSortMode(STOCommonParams.getInstance().getStoMode());
        } else {
            this.sorterStatus.setSortMode(SortControllerManager.getInstance().getCurrentSortType());
        }
        int clientStatus = DefaultClientManager.getInstance().getClientStatus();
        this.sorterStatus.setCurrentMode(currentMode);
        this.sorterStatus.setClientStatus(clientStatus);
        ICommand command = CommandCreator.getInstance().createCommand("SorterStatus", this.sorterStatus);
        SQLCommandExecutor.getInstance().executeCmd(command);
        command = CommandCreator.getInstance().createCommand("STOWebQuerySlotConfig", "");
        SQLCommandExecutor.getInstance().executeCmd(command);
        long currentTime = new Date().getTime();
        if (currentTime - STOSlotManager.getInstance().LastPacketOffTime > 120000L) {
            command = CommandCreator.getInstance().createCommand("STOFetchSlotWorkNum", "");
            SQLCommandExecutor.getInstance().executeCmd(command);
        }
    }

    private void initCommonParams() {
        YundaCommonParams.getInstance().init();
        STOCommonParams.getInstance().init();
    }

    private static class SorterParameterHolder {
        private static SorterCommonParams INSTANCE = new SorterCommonParams();

        private SorterParameterHolder() {
        }
    }
}

