/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.data.MachineInfo;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.IBarcodeQueryController;
import com.simba.server.controllers.IComplementController;
import com.simba.server.controllers.IMachineCloseController;
import com.simba.server.controllers.IMachineStartController;
import com.simba.server.controllers.IPacketOffController;
import com.simba.server.controllers.IPacketOnController;
import com.simba.server.controllers.IScannedController;
import com.simba.server.controllers.ISlotBindController;
import com.simba.server.controllers.ISlotFullController;
import com.simba.server.controllers.ISlotNormalController;
import com.simba.server.controllers.ISlotPackController;
import com.simba.server.controllers.ISlotUnlockController;
import com.simba.server.controllers.sto.STOBarcodeQueryController;
import com.simba.server.controllers.sto.STOComplementController;
import com.simba.server.controllers.sto.STOMachineCloseController;
import com.simba.server.controllers.sto.STOMachineStartController;
import com.simba.server.controllers.sto.STOPacketOffController;
import com.simba.server.controllers.sto.STOPacketOnController;
import com.simba.server.controllers.sto.STOScannedController;
import com.simba.server.controllers.sto.STOSlotBindController;
import com.simba.server.controllers.sto.STOSlotFullController;
import com.simba.server.controllers.sto.STOSlotNormalController;
import com.simba.server.controllers.sto.STOSlotPackController;
import com.simba.server.controllers.sto.STOSlotUnlockController;
import com.simba.server.controllers.yunda.YundaComplementController;
import com.simba.server.controllers.yunda.YundaMachineCloseController;
import com.simba.server.controllers.yunda.YundaMachineStartController;
import com.simba.server.controllers.yunda.YundaPacketOffController;
import com.simba.server.controllers.yunda.YundaPacketOnController;
import com.simba.server.controllers.yunda.YundaScannedController;
import com.simba.server.controllers.yunda.YundaSlotPackController;
import com.simba.server.controllers.yunda.YundaSlotUnlockController;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SortControllerManager
implements IPacketOnController,
IPacketOffController,
IScannedController,
ISlotPackController,
ISlotUnlockController,
ISlotBindController,
IComplementController,
IMachineCloseController,
IMachineStartController,
IBarcodeQueryController,
ISlotFullController,
ISlotNormalController {
    public static final String SORT_INFO_MODE_BEST = "Best";
    public static final String SORT_INFO_MODE_STO = "STO";
    public static final String SORT_INFO_MODE_YUNDA = "Yunda";
    private static final Logger logger = Logger.getLogger(SortControllerManager.class);
    private final HashMap<String, IComplementController> complementControllers = new HashMap();
    private volatile String currentSortInfoMode;
    private volatile String currentSortType;
    private final HashMap<String, IMachineCloseController> machineCloseControllers = new HashMap();
    private final HashMap<String, IMachineStartController> machineStartControllers = new HashMap();
    private final HashMap<String, IPacketOffController> packetOffControllers = new HashMap();
    private final HashMap<String, IPacketOnController> packetOnControllers = new HashMap();
    private final HashMap<String, IScannedController> scannedControllers = new HashMap();
    private final HashMap<String, ISlotBindController> slotBindControllers = new HashMap();
    private final HashMap<String, ISlotPackController> slotPackControllers = new HashMap();
    private final HashMap<String, ISlotUnlockController> slotUnlockControllers = new HashMap();
    private final HashMap<String, ISlotNormalController> slotNormalControllers = new HashMap();
    private final HashMap<String, ISlotFullController> slotFullControllers = new HashMap();
    private final HashMap<String, IBarcodeQueryController> barcodeQueryControllers = new HashMap();

    public static SortControllerManager getInstance() {
        return SortBusinessManagerHolder.INSTANCE;
    }

    private SortControllerManager() {
    }

    public String getCurrentSortInfoMode() {
        return this.currentSortInfoMode;
    }

    public void init() {
        try {
            this.currentSortInfoMode = SORT_INFO_MODE_STO;
            this.initPacketOnControllers();
            this.initScannedControllers();
            this.initPacketOffControllers();
            this.initSlotPackControllers();
            this.initSlotUnlockControllers();
            this.initSlotBindControllers();
            this.initComplementControllers();
            this.initMachineStartControllers();
            this.initMachineCloseControllers();
            this.initBarcodeQueryControllers();
            this.initSlotFullControllers();
            this.initSlotNormalControllers();
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Init Sort Business Manager Error -- Exception : " + ex, 2));
        }
    }

    @Override
    public void onComplementMessage(SortInfo sortInfo) {
        sortInfo.setSortInfoMode(this.currentSortInfoMode);
        IComplementController controller = this.complementControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onComplementMessage(sortInfo);
        }
        this.restoreComplementionInfo(sortInfo);
        this.sendComplementionToClient(sortInfo);
    }

    @Override
    public void onMachineCloseMessage(MachineInfo machineInfo) {
        IMachineCloseController controller = this.machineCloseControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onMachineCloseMessage(machineInfo);
        }
    }

    @Override
    public void onMachineStartMessage(MachineInfo machineInfo) {
        IMachineStartController controller = this.machineStartControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onMachineStartMessage(machineInfo);
        }
    }

    @Override
    public void onPacketOffMessage(SortInfo sortInfo) {
        sortInfo.setSortInfoMode(this.currentSortInfoMode);
        IPacketOffController controller = this.packetOffControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onPacketOffMessage(sortInfo);
        }
        this.restorePacketOffInfo(sortInfo);
        this.sendPacketOffToClient(sortInfo);
    }

    @Override
    public void onPacketOnMessage(SortInfo sortInfo) {
        sortInfo.setSortInfoMode(this.currentSortInfoMode);
        IPacketOnController controller = this.packetOnControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onPacketOnMessage(sortInfo);
        }
        this.restorePacketOnInfo(sortInfo);
        this.sendPacketOnToClient(sortInfo);
    }

    @Override
    public void onScannedMessage(SortInfo sortInfo) {
        sortInfo.setSortInfoMode(this.currentSortInfoMode);
        IScannedController controller = this.scannedControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onScannedMessage(sortInfo);
        }
        this.restoreScannedInfo(sortInfo);
        this.sendScannedInfoToClient(sortInfo);
    }

    @Override
    public void onSlotBindMessage(SlotInfo slotInfo) {
        slotInfo.setSortInfoMode(this.currentSortInfoMode);
        ISlotBindController controller = this.slotBindControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onSlotBindMessage(slotInfo);
        }
        this.restoreSlotBindInfo(slotInfo);
        this.sendSlotBindInfoToClient(slotInfo);
    }

    @Override
    public void onSlotPackMessage(SlotInfo slotInfo) {
        slotInfo.setSortInfoMode(this.currentSortInfoMode);
        ISlotPackController controller = this.slotPackControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onSlotPackMessage(slotInfo);
        }
        this.restoreSlotPackInfo(slotInfo);
        this.sendSlotPackInfoToClient(slotInfo);
    }

    @Override
    public void onSlotUnlockMessage(SlotInfo slotInfo) {
        slotInfo.setSortInfoMode(this.currentSortInfoMode);
        ISlotUnlockController controller = this.slotUnlockControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onSlotUnlockMessage(slotInfo);
        }
        this.restoreSlotUnlockInfo(slotInfo);
        this.sendSlotUnlockInfoToClient(slotInfo);
    }

    public void setCurrentSortInfoMode(String currentSortInfoMode) {
        this.currentSortInfoMode = currentSortInfoMode;
    }

    public void shutdown() {
    }

    private void initComplementControllers() {
        IComplementController controller = new YundaComplementController();
        this.complementControllers.put(SORT_INFO_MODE_YUNDA, controller);
        controller = new STOComplementController();
        this.complementControllers.put(SORT_INFO_MODE_STO, controller);
    }

    private void initMachineCloseControllers() {
        IMachineCloseController controller = new YundaMachineCloseController();
        this.machineCloseControllers.put(SORT_INFO_MODE_YUNDA, controller);
        controller = new STOMachineCloseController();
        this.machineCloseControllers.put(SORT_INFO_MODE_STO, controller);
    }

    private void initMachineStartControllers() {
        IMachineStartController controller = new YundaMachineStartController();
        this.machineStartControllers.put(SORT_INFO_MODE_YUNDA, controller);
        controller = new STOMachineStartController();
        this.machineStartControllers.put(SORT_INFO_MODE_STO, controller);
    }

    private void initBarcodeQueryControllers() {
        STOBarcodeQueryController controller = new STOBarcodeQueryController();
        this.barcodeQueryControllers.put(SORT_INFO_MODE_STO, controller);
    }

    private void initPacketOffControllers() {
        IPacketOffController controller = new YundaPacketOffController();
        this.packetOffControllers.put(SORT_INFO_MODE_YUNDA, controller);
        controller = new STOPacketOffController();
        this.packetOffControllers.put(SORT_INFO_MODE_STO, controller);
    }

    private void initPacketOnControllers() {
        IPacketOnController controller = new YundaPacketOnController();
        this.packetOnControllers.put(SORT_INFO_MODE_YUNDA, controller);
        controller = new STOPacketOnController();
        this.packetOnControllers.put(SORT_INFO_MODE_STO, controller);
    }

    private void initScannedControllers() {
        IScannedController controller = new YundaScannedController();
        this.scannedControllers.put(SORT_INFO_MODE_YUNDA, controller);
        controller = new STOScannedController();
        this.scannedControllers.put(SORT_INFO_MODE_STO, controller);
    }

    private void initSlotBindControllers() {
        STOSlotBindController controller = new STOSlotBindController();
        this.slotBindControllers.put(SORT_INFO_MODE_STO, controller);
    }

    private void initSlotPackControllers() {
        ISlotPackController controller = new YundaSlotPackController();
        this.slotPackControllers.put(SORT_INFO_MODE_YUNDA, controller);
        controller = new STOSlotPackController();
        this.slotPackControllers.put(SORT_INFO_MODE_STO, controller);
    }

    private void initSlotUnlockControllers() {
        ISlotUnlockController controller = new YundaSlotUnlockController();
        this.slotUnlockControllers.put(SORT_INFO_MODE_YUNDA, controller);
        controller = new STOSlotUnlockController();
        this.slotUnlockControllers.put(SORT_INFO_MODE_STO, controller);
    }

    private void initSlotFullControllers() {
        STOSlotFullController controller = new STOSlotFullController();
        this.slotFullControllers.put(SORT_INFO_MODE_STO, controller);
    }

    private void initSlotNormalControllers() {
        STOSlotNormalController controller = new STOSlotNormalController();
        this.slotNormalControllers.put(SORT_INFO_MODE_STO, controller);
    }

    private void restoreComplementionInfo(SortInfo sortInfo) {
    }

    private void restorePacketOffInfo(SortInfo sortInfo) {
    }

    private void restorePacketOnInfo(SortInfo toDefineSortInfo) {
    }

    private void restoreScannedInfo(SortInfo sortInfo) {
    }

    private void restoreSlotBindInfo(SlotInfo slotInfo) {
    }

    private void restoreSlotPackInfo(SlotInfo slotInfo) {
    }

    private void restoreSlotUnlockInfo(SlotInfo slotInfo) {
    }

    private void sendComplementionToClient(SortInfo sortInfo) {
    }

    private void sendPacketOffToClient(SortInfo sortInfo) {
        sortInfo.sendPacketOffToClient();
    }

    private void sendPacketOnToClient(SortInfo sortInfo) {
    }

    private void sendScannedInfoToClient(SortInfo sortInfo) {
    }

    private void sendSlotBindInfoToClient(SlotInfo slotInfo) {
    }

    private void sendSlotPackInfoToClient(SlotInfo slotInfo) {
    }

    private void sendSlotUnlockInfoToClient(SlotInfo slotInfo) {
    }

    @Override
    public void onBarcodeQueryMessage(SortInfo sortInfo) {
        IBarcodeQueryController controller = this.barcodeQueryControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onBarcodeQueryMessage(sortInfo);
        }
    }

    @Override
    public void onSlotNormalMessage(SlotInfo slotInfo) {
        ISlotNormalController controller = this.slotNormalControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onSlotNormalMessage(slotInfo);
        }
    }

    @Override
    public void onSlotFullMessage(SlotInfo slotInfo) {
        ISlotFullController controller = this.slotFullControllers.get(this.currentSortInfoMode);
        if (controller != null) {
            controller.onSlotFullMessage(slotInfo);
        }
    }

    public String getCurrentSortType() {
        return this.currentSortType;
    }

    public void setCurrentSortType(String currentSortType) {
        this.currentSortType = currentSortType;
    }

    private static class SortBusinessManagerHolder {
        private static final SortControllerManager INSTANCE = new SortControllerManager();

        private SortBusinessManagerHolder() {
        }
    }
}

