/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.SorterCommonParams;
import com.simba.server.components.data.PlcInfo;
import com.simba.server.components.data.SlotInfo;
import com.simba.server.components.data.TrashSlotInfo;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class SlotManager {
    public static final int TRASH_SLOT_NO_INFO = 1;
    public static final int TRASH_SLOT_NO_PLAN = 2;
    public static final int TRASH_SYSTEM_INTERCEPT = 3;
    public static final int TRASH_MAX_CIRCLE = 4;
    public static final int TRASH_SLOT_INTERCEPT = 5;
    public static final int TRASH_SLOT_NO_READ = 6;
    private static final Logger logger = Logger.getLogger(SlotManager.class);
    private final List<String> lockOverTimeTrashSlotList = new ArrayList<String>();
    private final List<String> noInfoTrashSlotList = new ArrayList<String>();
    private final List<String> noPlanTrashSlotList = new ArrayList<String>();
    private final List<String> noReadTrashSlotList = new ArrayList<String>();
    private final List<String> interceptTrashSlotList = new ArrayList<String>();
    private final ConcurrentHashMap<String, SlotInfo> slotInfoList = new ConcurrentHashMap();
    private final HashMap<String, PlcInfo> plcInfoMap = new HashMap();
    public SQLCommandExecutor stoRemoteDbSQLCommandExecutor = new SQLCommandExecutor();
    private final HashMap<Integer, String> arrivalSlotWorkNumMap = new HashMap();
    private final HashMap<Integer, String> departureSlotWorkNumMap = new HashMap();

    public static SlotManager getInstance() {
        return SlotManagerHolder.INSTANCE;
    }

    private SlotManager() {
    }

    public void addSlotInfo(SlotInfo slotInfo) {
        if (slotInfo != null) {
            this.slotInfoList.put(slotInfo.getSlotId(), slotInfo);
        }
    }

    public void clearSlotInfoList() {
        this.slotInfoList.clear();
    }

    public boolean containsSlotInfo(String key) {
        return this.slotInfoList.containsKey(key);
    }

    public String createSlotBindUUID() {
        UUID uuid = UUID.randomUUID();
        long now = System.currentTimeMillis();
        String timeInfo = String.valueOf(now);
        String uuidStr = uuid.toString() + "-" + timeInfo;
        return uuidStr;
    }

    public Boolean droppedSlotIsLockoverTime(int slot) {
        Boolean ret = false;
        if (this.lockOverTimeTrashSlotList.contains(String.valueOf(slot))) {
            ret = true;
        }
        return ret;
    }

    public Boolean droppedSlotIsNoInfo(int slot) {
        Boolean ret = false;
        if (this.noInfoTrashSlotList.contains(String.valueOf(slot))) {
            ret = true;
        }
        return ret;
    }

    public SlotInfo getSlotInfo(String key) {
        return this.slotInfoList.get(key.toLowerCase());
    }

    public int getSlotInfoCount() {
        return this.slotInfoList.size();
    }

    public SlotInfo[] getSlotInfoList() {
        return this.slotInfoList.values().toArray(new SlotInfo[0]);
    }

    public void init() {
        try {
            this.slotInfoList.clear();
            int slotNumber = SorterCommonParams.getInstance().getSlotNumber();
            for (int i = 0; i < slotNumber; ++i) {
                SlotInfo slotInfo = new SlotInfo();
                String slotId = String.valueOf(i);
                slotInfo.setSlotId(slotId);
                slotInfo.setPackCode(this.createSlotBindUUID());
                this.slotInfoList.put(slotId, slotInfo);
            }
            this.initTrashSlots();
            this.initPlcInfo();
            this.initPattern("sto");
            this.initBanciInfo();
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "init slot info  error: " + ex, 2));
        }
    }

    private void initPlcInfo() {
        try {
            ICommand command = CommandCreator.getInstance().createCommand("STOFetchPlcConfig", this.plcInfoMap);
            Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
            if (!ret.booleanValue()) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "init plc info  failed is table tt_sto_plc_config exist or not empty: ", 2));
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "init plc info  error: " + ex, 2));
        }
    }

    private void initBanciInfo() {
        try {
            ICommand command = CommandCreator.getInstance().createCommand("STOFetchShiftID", null);
            Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
            if (!ret.booleanValue()) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "fetch empty shiftID: ", 2));
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "initBanciInfo  error: " + ex, 2));
        }
    }

    private void initPattern(String custom) {
        try {
            ICommand command = CommandCreator.getInstance().createCommand("STOPattern", custom);
            Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
            if (!ret.booleanValue()) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "initPattern sto  failed is table tt_sto_plc_config exist or not empty: ", 2));
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "init plc info  error: " + ex, 2));
        }
    }

    public void initTrashSlots() {
        this.initNoReadTrashSlot();
        this.initNoInfoTrashSlot();
        this.initNoPlanTrashSlot();
        this.initInterCeptTrashSlot();
        this.initLockOverTimeTrashSlot();
    }

    public void postInitProcess() {
        String info = "No Read Trash slots : ";
        for (String trashSlot : this.noReadTrashSlotList) {
            info = info + trashSlot + ",";
        }
        info = info + "No Information Trash Slots:";
        for (String trashSlot : this.noInfoTrashSlotList) {
            info = info + trashSlot + ",";
        }
        info = info + "No SortPlan Trash Slots:";
        for (String trashSlot : this.noPlanTrashSlotList) {
            info = info + trashSlot + ",";
        }
        info = info + "Lock OverTime Trash Slots:";
        for (String trashSlot : this.lockOverTimeTrashSlotList) {
            info = info + trashSlot + ",";
        }
        info = info + "Intetcept Trash Slots:";
        for (String trashSlot : this.interceptTrashSlotList) {
            info = info + trashSlot + ",";
        }
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), info, 3));
    }

    public SlotInfo removeSlotInfo(String key) {
        return this.slotInfoList.remove(key);
    }

    private void initLockOverTimeTrashSlot() {
        List<String> lockOverTimeTrashSlotList;
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(4);
        ICommand command = CommandCreator.getInstance().createCommand("TrashSlots", trashSlotInfo);
        Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
        if (ret.booleanValue() && (lockOverTimeTrashSlotList = trashSlotInfo.getTrashSlots()) != null && lockOverTimeTrashSlotList.size() > 0) {
            this.setLockOverTimeTrashSlots(lockOverTimeTrashSlotList);
        }
    }

    private void initNoInfoTrashSlot() {
        List<String> noInformationTrashSlotList;
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(1);
        ICommand command = CommandCreator.getInstance().createCommand("TrashSlots", trashSlotInfo);
        Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
        if (ret.booleanValue() && (noInformationTrashSlotList = trashSlotInfo.getTrashSlots()) != null && noInformationTrashSlotList.size() > 0) {
            this.setNoInfoTrashSlots(noInformationTrashSlotList);
        }
    }

    private void initInterCeptTrashSlot() {
        List<String> interceptTrashSlotList;
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(5);
        ICommand command = CommandCreator.getInstance().createCommand("TrashSlots", trashSlotInfo);
        Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
        if (ret.booleanValue() && (interceptTrashSlotList = trashSlotInfo.getTrashSlots()) != null && interceptTrashSlotList.size() > 0) {
            this.seInterCeptTrashSlots(interceptTrashSlotList);
        }
    }

    private void initNoPlanTrashSlot() {
        List<String> noInformationTrashSlotList;
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(2);
        ICommand command = CommandCreator.getInstance().createCommand("TrashSlots", trashSlotInfo);
        Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
        if (ret.booleanValue() && (noInformationTrashSlotList = trashSlotInfo.getTrashSlots()) != null && noInformationTrashSlotList.size() > 0) {
            this.setNoPlanTrashSlots(noInformationTrashSlotList);
        }
    }

    private void initNoReadTrashSlot() {
        List<String> noInformationTrashSlotList;
        TrashSlotInfo trashSlotInfo = new TrashSlotInfo();
        trashSlotInfo.setTypeId(6);
        ICommand command = CommandCreator.getInstance().createCommand("TrashSlots", trashSlotInfo);
        Boolean ret = SQLCommandExecutor.getInstance().executeCmd(command);
        if (ret.booleanValue() && (noInformationTrashSlotList = trashSlotInfo.getTrashSlots()) != null && noInformationTrashSlotList.size() > 0) {
            this.setNoReadTrashSlots(noInformationTrashSlotList);
        }
    }

    private void setLockOverTimeTrashSlots(List<String> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.lockOverTimeTrashSlotList.clear();
        this.lockOverTimeTrashSlotList.addAll(configTrashSlots);
    }

    private void setNoInfoTrashSlots(List<String> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.noInfoTrashSlotList.clear();
        this.noInfoTrashSlotList.addAll(configTrashSlots);
    }

    public List<String> getNoInfoTrashSlots() {
        return this.noInfoTrashSlotList;
    }

    private void setNoPlanTrashSlots(List<String> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.noPlanTrashSlotList.clear();
        this.noPlanTrashSlotList.addAll(configTrashSlots);
    }

    private void seInterCeptTrashSlots(List<String> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.interceptTrashSlotList.clear();
        this.interceptTrashSlotList.addAll(configTrashSlots);
    }

    public List<String> getInterCeptSlots() {
        return this.interceptTrashSlotList;
    }

    public List<String> getNoPlanTrashSlots() {
        return this.noPlanTrashSlotList;
    }

    private void setNoReadTrashSlots(List<String> configTrashSlots) {
        if (configTrashSlots == null || configTrashSlots.size() == 0) {
            return;
        }
        this.noReadTrashSlotList.clear();
        this.noReadTrashSlotList.addAll(configTrashSlots);
    }

    public PlcInfo getPlcInfoByPlatID(int platID) {
        PlcInfo plcInfo;
        block3: {
            plcInfo = null;
            try {
                if (this.plcInfoMap == null || this.plcInfoMap.size() <= 0) break block3;
                for (PlcInfo pValue : this.plcInfoMap.values()) {
                    if (platID < pValue.getMinPlatID() || platID > pValue.getMaxPlatID()) continue;
                    plcInfo = pValue;
                    break;
                }
            }
            catch (Exception EX) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "getPlcInfoByPlatID error" + EX.getMessage(), 2));
            }
        }
        return plcInfo;
    }

    public PlcInfo getPlcInfoByChannel(Channel connection) {
        PlcInfo plcInfo = null;
        try {
            SocketAddress sckAddr = connection.getRemoteAddress();
            String strAddr = sckAddr.toString();
            if (strAddr.contains(":")) {
                strAddr = strAddr.substring(0, strAddr.indexOf(":"));
            }
            if (strAddr.startsWith("/")) {
                strAddr = strAddr.substring(1);
            }
            if (this.plcInfoMap != null && this.plcInfoMap.size() > 0) {
                if (this.plcInfoMap.containsKey(strAddr)) {
                    plcInfo = this.plcInfoMap.get(strAddr);
                } else {
                    LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "getPlcInfoByChannel error not conatain addr " + strAddr, 2));
                }
            }
        }
        catch (Exception EX) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "getPlcInfoByChannel error" + EX.getMessage(), 2));
        }
        return plcInfo;
    }

    public String getServerReason(int serverErrorCode) {
        String strRes = "\u6210\u529f";
        switch (serverErrorCode) {
            case 1: {
                strRes = "\u65e0\u4fe1\u606f ";
                break;
            }
            case 2: {
                strRes = "\u65e0\u65b9\u6848";
                break;
            }
            case 3: {
                strRes = "\u7cfb\u7edf\u62e6\u622a\u4ef6";
                break;
            }
            case 4: {
                strRes = "\u9501\u683c\u8d85\u65f6";
                break;
            }
            case 5: {
                strRes = "\u672c\u5730\u62e6\u622a\u4ef6";
                break;
            }
            case 6: {
                strRes = "\u65e0\u8bfb\u4ef6";
            }
        }
        return strRes;
    }

    public boolean isSlotOverTime(String droppedSlot, String slots) {
        boolean res = true;
        try {
            String[] arrSlot;
            for (String strSlot : arrSlot = slots.split(",")) {
                if (!strSlot.equalsIgnoreCase(droppedSlot)) continue;
                res = false;
                break;
            }
        }
        catch (Exception EX) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "isSlotOverTime error" + EX.getMessage(), 2));
        }
        return res;
    }

    public HashMap<Integer, String> getArrivalSlotWorkNumMap() {
        return this.arrivalSlotWorkNumMap;
    }

    public HashMap<Integer, String> getDepartureSlotWorkNumMap() {
        return this.departureSlotWorkNumMap;
    }

    private static class SlotManagerHolder {
        private static final SlotManager INSTANCE = new SlotManager();

        private SlotManagerHolder() {
        }
    }
}

