/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.common.command.ICommand;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.utils.FrameUtils;
import com.simba.server.commands.CommandCreator;
import com.simba.server.components.CommonDefines;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.SortInfoManager;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.PlcInfo;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.sto.STOCommonParams;
import com.simba.server.controllers.sto.data.STOSlotManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.json.JSONObject;

public class PlatInstance {
    private static final Logger logger = Logger.getLogger(PlatInstance.class);
    private Channel platClient;
    private final String platId;
    private final ConcurrentHashMap<String, SortInfo> unDefinedSortInfos = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, SortInfo> videoSortInfos = new ConcurrentHashMap();
    private String workerNo;
    private Channel videoChannel = null;

    public PlatInstance(String toPlatId) {
        this.platId = toPlatId;
    }

    public Channel getPlatClient() {
        return this.platClient;
    }

    public String getPlatId() {
        return this.platId;
    }

    public String getWorkerNo() {
        return this.workerNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePacketOnCommand(String toPlatId, String barcode, String carId, String plcId, String platMode, String carFlag, String physicPlatID) {
        SortInfo toDefineSortInfo = null;
        try {
            int isNeedVideoCoding;
            if (!this.platId.equalsIgnoreCase(toPlatId) || barcode == null) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handlePacketOnCommand failed this platId=" + this.platId + " toPlatId=" + toPlatId + " barcode=" + barcode, 2));
                return;
            }
            if (!this.unDefinedSortInfos.containsKey(barcode)) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "unDefinedSortInfos not contain barcode=" + barcode, 2));
                return;
            }
            toDefineSortInfo = this.unDefinedSortInfos.get(barcode);
            toDefineSortInfo.setCarId(carFlag + "-" + carId);
            toDefineSortInfo.setPlatMode(platMode);
            toDefineSortInfo.setPlatId(toPlatId);
            toDefineSortInfo.setPlcId(plcId);
            toDefineSortInfo.setPlcPlatID(Integer.parseInt(physicPlatID));
            toDefineSortInfo.setTimePacketOn(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
            toDefineSortInfo.setTimestampPacketOn(SorterProtocolCreator.getInstance().createCurrentTimeStamp());
            if (this.videoSortInfos.size() > 5000) {
                this.videoSortInfos.clear();
            }
            if ((isNeedVideoCoding = toDefineSortInfo.getIsNeedVideoCoding()) == 1) {
                SortInfoManager.getInstance().mapNoInfoBarcodes.put(barcode, Integer.parseInt(carId));
                SortInfoManager.getInstance().taskAssign(barcode);
                this.videoSortInfos.put(barcode, toDefineSortInfo);
            }
            SortInfoManager.getInstance().addSortInfo(toDefineSortInfo);
            SortControllerManager.getInstance().onPacketOnMessage(toDefineSortInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Packet On Message Error -- Exception : " + ex, 2));
        }
        finally {
            if (this.unDefinedSortInfos.containsKey(barcode)) {
                this.unDefinedSortInfos.remove(barcode);
            }
        }
    }

    public void handleScannedCommand(Channel toPlatClient, JSONObject dataObj) {
        try {
            String toPlatId = dataObj.getString("platId");
            String barcode = dataObj.getString("barcode");
            String weight = dataObj.getString("weight");
            if (!this.platId.equalsIgnoreCase(toPlatId) || barcode == null) {
                return;
            }
            if (toPlatClient != null && this.platClient != toPlatClient) {
                this.setPlatClient(toPlatClient);
            }
            SortInfo unDefinedsortInfo = SortInfoManager.getInstance().createSortInfo();
            unDefinedsortInfo.setBarcode(barcode);
            unDefinedsortInfo.getBarcodeList().add(barcode);
            unDefinedsortInfo.setPlatId(toPlatId);
            unDefinedsortInfo.setWeight(weight);
            int plcPlatID = Integer.parseInt(toPlatId);
            if (plcPlatID > STOCommonParams.getInstance().getEachLayerPlatNums()) {
                plcPlatID -= STOCommonParams.getInstance().getEachLayerPlatNums();
            }
            if (plcPlatID > STOCommonParams.getInstance().getEachLayerPlatNums()) {
                plcPlatID -= STOCommonParams.getInstance().getEachLayerPlatNums();
            }
            unDefinedsortInfo.setPlcPlatID(plcPlatID);
            unDefinedsortInfo.setTimeScanned(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
            unDefinedsortInfo.setTimestampScanned(SorterProtocolCreator.getInstance().createCurrentTimeStamp());
            unDefinedsortInfo.setDataObj(dataObj);
            this.unDefinedSortInfos.put(barcode, unDefinedsortInfo);
            SortControllerManager.getInstance().onScannedMessage(unDefinedsortInfo);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Scanner Message With Simple Mode Error -- Exception : " + ex, 2));
        }
    }

    public void init() {
    }

    public void resetPlat() {
        try {
            this.unDefinedSortInfos.clear();
            this.sendResetMsgToPLC();
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Reset Provide Plat Message Error -- Exception : " + ex, 2));
        }
    }

    public void resetSelf() {
        this.unDefinedSortInfos.clear();
        this.sendResetMsgToPLC();
    }

    public void setPlatClient(Channel providePlatClient) {
        this.platClient = providePlatClient;
    }

    public void setWorkerNo(String workerNumber) {
        this.workerNo = workerNumber;
    }

    private void sendResetMsgToPLC() {
        Channel[] channels;
        int platIdValue = Integer.parseInt(this.platId);
        byte[] sendContent = SorterProtocolCreator.getInstance().createResetPlatBuffer(platIdValue);
        for (Channel channel : channels = FrameChannelManager.getInstance().getChannelList()) {
            FrameChannelManager.getInstance().commitResponse(channel, sendContent, false);
        }
    }

    public Channel getVideoChannel() {
        return this.videoChannel;
    }

    public void setVideoChannel(Channel videoChannel) {
        this.videoChannel = videoChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleVideoCodingMessage(String toProvidePlatId, String barcode, String carId, String Code1, String Code2, String Code3, String workerNumber) {
        SortInfo toDefineSortInfo = null;
        try {
            if (!this.platId.equalsIgnoreCase(toProvidePlatId) || barcode == null || carId == null) {
                return;
            }
            if (!this.videoSortInfos.containsKey(barcode)) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "videoSortInfos not contain barcode " + barcode, 2));
                return;
            }
            toDefineSortInfo = this.videoSortInfos.get(barcode);
            if (toDefineSortInfo == null) {
                return;
            }
            System.out.println("find sort info:");
            JSONObject jsobj = toDefineSortInfo.getDataObj();
            jsobj.put("Code1", Code1);
            jsobj.put("Code2", Code2);
            jsobj.put("Code3", Code3);
            jsobj.put("workerNumber", workerNumber);
            toDefineSortInfo.setDataObj(jsobj);
            toDefineSortInfo.getSlotsList().clear();
            if (STOCommonParams.getInstance().getStoMode().contains("dep")) {
                this.handleDepartureSortInfo(toDefineSortInfo);
            } else {
                this.handleArrivalVideoTask(toDefineSortInfo);
            }
            this.sendVideoResult(toDefineSortInfo);
            this.sendVideoSortInfoMsgToPlc(toDefineSortInfo);
            this.videoSortInfos.remove(barcode);
            if (this.videoSortInfos.size() > 5000) {
                this.videoSortInfos.clear();
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleVideoCodingMessage Error -- Exception : " + ex, 2));
        }
        finally {
            if (this.unDefinedSortInfos.containsKey(barcode)) {
                this.unDefinedSortInfos.remove(barcode);
            }
        }
    }

    private boolean handleArrivalVideoTask(SortInfo sortInfo) {
        Boolean res = false;
        try {
            JSONObject dataObj = sortInfo.getDataObj();
            dataObj.put("stoMode", "arrival");
            ICommand command = CommandCreator.getInstance().createCommand("STOSortPlanA", sortInfo);
            res = SQLCommandExecutor.getInstance().executeCmd(command);
            if (res.booleanValue()) {
                System.out.println("handleArrivalVideoTask:success");
                sortInfo.setIsVideoCodingSuccess(1);
            } else {
                System.out.println("handleArrivalVideoTask:failed");
                sortInfo.setIsVideoCodingSuccess(0);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleArrivalVideoTask Error -- Exception : " + ex, 2));
        }
        return res;
    }

    private boolean handleDepartureSortInfo(SortInfo sortInfo) {
        Boolean res = false;
        try {
            JSONObject dataObj = sortInfo.getDataObj();
            dataObj.put("stoMode", "departure");
            ICommand command = CommandCreator.getInstance().createCommand("STOSortPlanD", sortInfo);
            res = SQLCommandExecutor.getInstance().executeCmd(command);
            if (res.booleanValue()) {
                this.handleNormalSortInfo(sortInfo);
                sortInfo.setIsVideoCodingSuccess(1);
            } else {
                sortInfo.setIsVideoCodingSuccess(0);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleDepartureSortInfo Error -- Exception : " + ex, 2));
        }
        return res;
    }

    private void handleNormalSortInfo(SortInfo sortInfo) {
        try {
            List<Integer> slots = sortInfo.getSlotsList();
            boolean isAllSlotLock = true;
            LinkedList<Integer> slotsLocked = new LinkedList<Integer>();
            LinkedList<Integer> slotsUnbinded = new LinkedList<Integer>();
            LinkedList<Integer> slotsValid = new LinkedList<Integer>();
            int unBindCount = 0;
            int slotsCount = slots.size();
            sortInfo.setDroppedErrorCode(0);
            sortInfo.setServerErrorCode(0);
            JSONObject dataObject = sortInfo.getDataObj();
            String strModel = dataObject.getString("stoMode");
            if (strModel.equalsIgnoreCase("departure")) {
                String strPackage;
                int bindedSlot = 0;
                for (Integer Slot : slots) {
                    boolean isSlotLock = true;
                    if (!SlotManager.getInstance().droppedSlotIsLockoverTime(Slot).booleanValue()) {
                        isAllSlotLock = false;
                        isSlotLock = false;
                    } else if (!slotsLocked.contains(Slot)) {
                        slotsLocked.add(Slot);
                    }
                    if (STOSlotManager.getInstance().getMapBindPacket().containsKey(String.valueOf(Slot))) {
                        strPackage = STOSlotManager.getInstance().getMapBindPacket().get(String.valueOf(Slot));
                        if (strPackage.contains("unbind")) {
                            if (!slotsUnbinded.contains(Slot)) {
                                slotsUnbinded.add(Slot);
                            }
                            ++unBindCount;
                            continue;
                        }
                        if (isSlotLock) continue;
                        bindedSlot = Slot;
                        slotsValid.add(Slot);
                        continue;
                    }
                    if (!slotsUnbinded.contains(Slot)) {
                        slotsUnbinded.add(Slot);
                    }
                    ++unBindCount;
                }
                if (isAllSlotLock) {
                    dataObject.put("msg", "lock");
                    if (slotsUnbinded.size() > 0) {
                        sortInfo.getSlotsList().clear();
                        for (Integer lockedSlot : slotsLocked) {
                            sortInfo.getSlotsList().add(lockedSlot);
                        }
                    }
                } else if (unBindCount == slotsCount) {
                    dataObject.put("msg", "unbind");
                    if (slotsUnbinded.size() > 0) {
                        sortInfo.getSlotsList().clear();
                        String unBindedSlots = "";
                        for (Integer unbinedSlot : slotsUnbinded) {
                            sortInfo.getSlotsList().add(unbinedSlot);
                            unBindedSlots = unBindedSlots + unbinedSlot.toString() + " ";
                        }
                        unBindedSlots = unBindedSlots.trim();
                    }
                } else {
                    String strPackageList = "";
                    sortInfo.getSlotsList().clear();
                    for (Integer Slot : slotsValid) {
                        if (!STOSlotManager.getInstance().getMapBindPacket().containsKey(String.valueOf(Slot))) continue;
                        strPackage = STOSlotManager.getInstance().getMapBindPacket().get(String.valueOf(Slot));
                        strPackageList = strPackageList + String.valueOf(Slot) + "=" + strPackage + ",";
                        sortInfo.getSlotsList().add(Slot);
                    }
                    if (strPackageList.endsWith(",")) {
                        strPackageList = strPackageList.substring(0, strPackageList.length() - 1);
                        dataObject.put("sto-pckcode", strPackageList);
                        sortInfo.setDataObj(dataObject);
                        sortInfo.setPackCode(strPackageList);
                    }
                }
            } else {
                sortInfo.setDataObj(dataObject);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Sto handleNormalSortInfo Error -- Exception : " + ex, 2));
        }
    }

    private void sendVideoSortInfoMsgToPlc(SortInfo sortInfo) {
        Channel[] channels;
        if (sortInfo == null) {
            return;
        }
        byte[] sendContent = this.createVideoSortResultBuffer(sortInfo);
        String platID = sortInfo.getPlatId();
        PlcInfo plcInfo = SlotManager.getInstance().getPlcInfoByPlatID(Integer.parseInt(platID));
        if (plcInfo == null) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "sendVideoSortInfoMsgToPlcError -- plcInfo==null: platid=" + platID, 2));
            return;
        }
        for (Channel channel : channels = FrameChannelManager.getInstance().getChannelList()) {
            if (!channel.getRemoteAddress().toString().contains(plcInfo.getPlcAddr())) continue;
            FrameChannelManager.getInstance().commitResponse(channel, sendContent, false);
            break;
        }
    }

    private void sendVideoResult(SortInfo sortInfo) {
        try {
            String barCode = sortInfo.getBarcode();
            JSONObject responseObj = new JSONObject();
            responseObj.put("ServiceName", "SortResult");
            responseObj.put("platId", sortInfo.getPlatId());
            responseObj.put("barcode", barCode);
            String slots = "";
            if (sortInfo.getSlotsList().size() > 0) {
                for (int slot : sortInfo.getSlotsList()) {
                    slots = slots + String.valueOf(slot) + "|";
                }
            }
            if (!slots.equalsIgnoreCase("")) {
                responseObj.put("factualSlot", slots.substring(0, slots.length() - 1));
            } else {
                responseObj.put("factualSlot", "0");
            }
            if (sortInfo.getIsVideoCodingSuccess() > 0) {
                responseObj.put("status", "True");
            } else {
                responseObj.put("status", "False");
            }
            Channel channel = this.getVideoChannel();
            if (channel != null && channel.isConnected()) {
                String sendContent = responseObj.toString();
                JsonChannelManager.getInstance().commitResponse(channel, sendContent.getBytes(), false);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "sendVideoResult catch an exception : " + ex.getMessage(), 2));
        }
    }

    private void sendVideoTask(SortInfo sortInfo) {
        try {
            String barCode = sortInfo.getBarcode();
            JSONObject responseObj = new JSONObject();
            responseObj.put("ServiceName", "VideoCoding");
            responseObj.put("platId", sortInfo.getPlatId());
            responseObj.put("barcode", barCode);
            Channel channel = this.getVideoChannel();
            if (channel != null && channel.isConnected()) {
                Date date = new Date();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String sendContent = responseObj.toString();
                JsonChannelManager.getInstance().commitResponse(channel, sendContent.getBytes(), false);
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), " send video task to " + channel.getRemoteAddress() + " content is " + sendContent, 1));
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "sendVideoTaskT catch an exception : " + ex.getMessage(), 2));
        }
    }

    private byte[] createVideoSortResultBuffer(SortInfo sortInfo) {
        String plcId = sortInfo.getPlcId();
        int slotNumber = sortInfo.getSlotsList().size();
        byte[] replyBuffer = new byte[21 + 2 * slotNumber + plcId.length()];
        int position = 0;
        byte[] header = CommonDefines.REPLY_HEADER;
        System.arraycopy(header, 0, replyBuffer, position, header.length);
        byte[] command = new byte[]{7};
        System.arraycopy(command, 0, replyBuffer, position += header.length, command.length);
        String carId = sortInfo.getCarId();
        byte[] carIdBuf = new byte[2];
        FrameUtils.getInstance().setShortBigEndian(0, Integer.parseInt(carId), carIdBuf);
        System.arraycopy(carIdBuf, 0, replyBuffer, position += command.length, carIdBuf.length);
        byte[] statusAndOBR = new byte[]{0, 1};
        System.arraycopy(statusAndOBR, 0, replyBuffer, position += carIdBuf.length, statusAndOBR.length);
        int slotsSum = slotNumber;
        byte[] slotlen = new byte[]{(byte)slotsSum};
        System.arraycopy(slotlen, 0, replyBuffer, position += statusAndOBR.length, slotlen.length);
        position += slotlen.length;
        for (int i = 0; i < slotsSum; ++i) {
            int yundaslotId = sortInfo.getSlotsList().get(i);
            byte[] slotBuf = new byte[2];
            FrameUtils.getInstance().setShortBigEndian(0, yundaslotId, slotBuf);
            System.arraycopy(slotBuf, 0, replyBuffer, position, slotBuf.length);
            position += slotBuf.length;
        }
        byte[] slotUnusual = new byte[]{0};
        System.arraycopy(slotUnusual, 0, replyBuffer, position, slotUnusual.length);
        byte[] plcidLen = new byte[]{(byte)plcId.length()};
        System.arraycopy(plcidLen, 0, replyBuffer, position += slotUnusual.length, plcidLen.length);
        byte[] plcid = plcId.getBytes();
        System.arraycopy(plcid, 0, replyBuffer, position += plcidLen.length, plcid.length);
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddHHmmss");
        String timeNow = dateFormat.format(new Date());
        byte[] systemTime = timeNow.getBytes();
        System.arraycopy(systemTime, 0, replyBuffer, position += plcid.length, systemTime.length);
        byte[] serialByte = new byte[]{1};
        System.arraycopy(serialByte, 0, replyBuffer, position += systemTime.length, serialByte.length);
        byte[] replayEnder = CommonDefines.REPLY_ENDER;
        System.arraycopy(replayEnder, 0, replyBuffer, position += serialByte.length, replayEnder.length);
        position += replayEnder.length;
        return replyBuffer;
    }

    public void handleVideoRegistCommand(Channel toPlatClient, JSONObject dataObj) {
        try {
            String toPlatId = dataObj.getString("platId");
            if (!this.platId.equalsIgnoreCase(toPlatId)) {
                return;
            }
            if (toPlatClient != null && this.platClient != toPlatClient) {
                this.setPlatClient(toPlatClient);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "handleVideoRegistCommand Error -- Exception : " + ex, 2));
        }
    }
}

