/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.components;

import com.simba.server.controllers.sto.STOCommonParams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

public class FtpUtils {
    public Integer port = 21;
    public FTPClient ftpClient = null;

    public void initFtpClient() {
        this.ftpClient = new FTPClient();
        this.ftpClient.setControlEncoding("utf-8");
        try {
            this.ftpClient.connect(STOCommonParams.getInstance().getServerFtpUrl(), (int)this.port);
            this.ftpClient.login(STOCommonParams.getInstance().getFtpUser(), STOCommonParams.getInstance().getFtpPwd());
            int n = this.ftpClient.getReplyCode();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFile(String pathname, String filename) {
        boolean flag = false;
        try {
            this.initFtpClient();
            this.ftpClient.changeWorkingDirectory(pathname);
            this.ftpClient.dele(filename);
            this.ftpClient.logout();
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.ftpClient.isConnected()) {
                try {
                    this.ftpClient.disconnect();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    public void RemoveDir(String path) {
        try {
            this.initFtpClient();
            FTPFile[] files = this.ftpClient.listFiles(path);
            this.ftpClient.disconnect();
            for (FTPFile file : files) {
                if (file.isDirectory()) {
                    if (this.existFile(path + "/" + file.getName())) {
                        this.RemoveDir(path + "/" + file.getName());
                        continue;
                    }
                    this.removeDirectory(path + "/" + file.getName());
                    continue;
                }
                this.deleteFile(path, file.getName());
            }
            this.initFtpClient();
            this.removeDirectory(path);
        }
        catch (Exception ex) {
            System.out.println("Catch an exception in FtpUtils.RemoveDir:" + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDirectory(String dirName) {
        boolean flag = false;
        try {
            this.initFtpClient();
            this.ftpClient.removeDirectory(dirName);
            this.ftpClient.logout();
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.ftpClient.isConnected()) {
                try {
                    this.ftpClient.disconnect();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String pathname, String fileName, String originfilename) {
        boolean flag = false;
        FileInputStream inputStream = null;
        try {
            System.out.println("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6");
            inputStream = new FileInputStream(new File(originfilename));
            this.initFtpClient();
            this.ftpClient.setFileType(2);
            this.CreateDirecroty(pathname);
            this.ftpClient.makeDirectory(pathname);
            this.ftpClient.changeWorkingDirectory(pathname);
            this.ftpClient.storeFile(fileName, inputStream);
            ((InputStream)inputStream).close();
            this.ftpClient.logout();
            flag = true;
            System.out.println("\u4e0a\u4f20\u6587\u4ef6\u6210\u529f");
        }
        catch (Exception e) {
            System.out.println("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
            e.printStackTrace();
        }
        finally {
            if (this.ftpClient.isConnected()) {
                try {
                    this.ftpClient.disconnect();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != inputStream) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String pathname, String fileName, InputStream inputStream) {
        boolean flag = false;
        try {
            System.out.println("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6");
            this.initFtpClient();
            this.ftpClient.setFileType(2);
            this.CreateDirecroty(pathname);
            this.ftpClient.makeDirectory(pathname);
            this.ftpClient.changeWorkingDirectory(pathname);
            this.ftpClient.storeFile(fileName, inputStream);
            inputStream.close();
            this.ftpClient.logout();
            flag = true;
            System.out.println("\u4e0a\u4f20\u6587\u4ef6\u6210\u529f");
        }
        catch (Exception e) {
            System.out.println("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
            e.printStackTrace();
        }
        finally {
            if (this.ftpClient.isConnected()) {
                try {
                    this.ftpClient.disconnect();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public boolean changeWorkingDirectory(String directory) {
        boolean flag = true;
        try {
            flag = this.ftpClient.changeWorkingDirectory(directory);
            if (flag) {
                System.out.println("\u8fdb\u5165\u6587\u4ef6\u5939" + directory + " \u6210\u529f\uff01");
            } else {
                System.out.println("\u8fdb\u5165\u6587\u4ef6\u5939" + directory + " \u5931\u8d25\uff01\u5f00\u59cb\u521b\u5efa\u6587\u4ef6\u5939");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return flag;
    }

    public boolean CreateDirecroty(String remote) throws IOException {
        boolean success;
        block5: {
            success = true;
            String directory = remote + "/";
            if (directory.equalsIgnoreCase("/") || this.changeWorkingDirectory(new String(directory))) break block5;
            int start = 0;
            int end = 0;
            start = directory.startsWith("/") ? 1 : 0;
            end = directory.indexOf("/", start);
            String path = "";
            String paths = "";
            do {
                String subDirectory = new String(remote.substring(start, end).getBytes("GBK"), "iso-8859-1");
                if (!this.existFile(path = path + "/" + subDirectory)) {
                    if (this.makeDirectory(subDirectory)) {
                        this.changeWorkingDirectory(subDirectory);
                    } else {
                        System.out.println("\u521b\u5efa\u76ee\u5f55[" + subDirectory + "]\u5931\u8d25");
                        this.changeWorkingDirectory(subDirectory);
                    }
                } else {
                    this.changeWorkingDirectory(subDirectory);
                }
                paths = paths + "/" + subDirectory;
            } while ((end = directory.indexOf("/", start = end + 1)) > start);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existFile(String path) throws IOException {
        boolean flag = false;
        try {
            this.initFtpClient();
            FTPFile[] ftpFileArr = this.ftpClient.listFiles(path);
            if (ftpFileArr.length > 0) {
                flag = true;
            }
        }
        catch (Exception ex) {
            flag = false;
        }
        finally {
            if (this.ftpClient.isConnected()) {
                try {
                    this.ftpClient.disconnect();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    public boolean makeDirectory(String dir) {
        boolean flag = true;
        try {
            flag = this.ftpClient.makeDirectory(dir);
            if (flag) {
                System.out.println("\u521b\u5efa\u6587\u4ef6\u5939" + dir + " \u6210\u529f\uff01");
            } else {
                System.out.println("\u521b\u5efa\u6587\u4ef6\u5939" + dir + " \u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFile(String pathname, String filename, String localpath) {
        boolean flag = false;
        OutputStream os = null;
        try {
            FTPFile[] ftpFiles;
            System.out.println("\u5f00\u59cb\u4e0b\u8f7d\u6587\u4ef6");
            this.initFtpClient();
            this.ftpClient.changeWorkingDirectory(pathname);
            for (FTPFile file : ftpFiles = this.ftpClient.listFiles()) {
                if (!filename.equalsIgnoreCase(file.getName())) continue;
                File localFile = new File(localpath + "/" + file.getName());
                os = new FileOutputStream(localFile);
                this.ftpClient.retrieveFile(file.getName(), os);
                os.close();
            }
            this.ftpClient.logout();
            flag = true;
            System.out.println("\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f");
        }
        catch (Exception e) {
            System.out.println("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25");
            e.printStackTrace();
        }
        finally {
            if (this.ftpClient.isConnected()) {
                try {
                    this.ftpClient.disconnect();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != os) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }
}

