/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.yunda;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.data.SortInfo;
import org.json.JSONObject;

public class YundaPacketOffCmd
implements ICommand {
    private final SortInfo sortInfo;
    private final String sql = "insert into tt_yunda_packet_off(barcode,carId,platId,platMode,obrNumber,destinationCode,droppedSlot,droppedTimeStamp,droppedErrorCode,bindUUID,plcId,interceptFlag,slotSource,logicSlot) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?);";

    public YundaPacketOffCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return "YundaPacketOff";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        JSONObject dataobj = this.sortInfo.getDataObj();
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            String barcode = this.sortInfo.getBarcode();
            if (barcode == null || barcode.equals("")) {
                barcode = "none";
            }
            dbOperator.setString(1, barcode);
            String carId = this.sortInfo.getCarId();
            if (carId == null || carId.equals("")) {
                carId = "0";
            }
            dbOperator.setString(2, carId);
            String platId = this.sortInfo.getPlatId();
            if (platId == null || platId.equals("")) {
                platId = "0";
            }
            dbOperator.setString(3, platId);
            String platMode = this.sortInfo.getPlatMode();
            if (platMode == null || platMode.equals("")) {
                platMode = "none";
            }
            dbOperator.setString(4, platMode);
            int obrNumber = this.sortInfo.getObr();
            dbOperator.setInt(5, obrNumber);
            String destinationCode = dataobj.getString("slotsContent");
            if (destinationCode == null || destinationCode.equals("")) {
                destinationCode = "none";
            }
            dbOperator.setString(6, destinationCode);
            int droppedSlot = this.sortInfo.getDroppedSlotId();
            dbOperator.setInt(7, droppedSlot);
            String droppedTimeStamp = this.sortInfo.getTimePacketOff();
            if (droppedTimeStamp == null || droppedTimeStamp.equals("")) {
                droppedTimeStamp = "none";
            }
            dbOperator.setString(8, droppedTimeStamp);
            int droppedErrorCode = this.sortInfo.getDroppedErrorCode();
            dbOperator.setInt(9, droppedErrorCode);
            String bindUUID = this.sortInfo.getPackCode();
            if (bindUUID == null || bindUUID.equals("")) {
                bindUUID = "none";
            }
            dbOperator.setString(10, bindUUID);
            String plcId = this.sortInfo.getPlcId();
            if (plcId == null || plcId.equals("")) {
                plcId = "none";
            }
            dbOperator.setString(11, plcId);
            int interceptFlag = this.sortInfo.getInterceptFlag();
            dbOperator.setInt(12, interceptFlag);
            String slotSource = dataobj.getString("sortMode");
            if (slotSource == null || slotSource.equals("")) {
                slotSource = "none";
            }
            dbOperator.setString(13, slotSource);
            String logicSlot = dataobj.getString("logicSlot");
            if (logicSlot == null || logicSlot.equals("")) {
                logicSlot = "none";
            }
            dbOperator.setString(14, logicSlot);
            int res = dbOperator.executeUpdate();
            ret = res <= 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

