/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.yunda;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.data.SortInfo;
import org.json.JSONObject;

public class YundaComplementCmd
implements ICommand {
    private final SortInfo sortInfo;
    private final String sql = "insert into tt_yunda_video_result(barCode,slots,platId,carId,result,cpFlag) values(?,?,?,?,?,?);";

    public YundaComplementCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return "YundaComplement";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        JSONObject daJsonObject = this.sortInfo.getDataObj();
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            String barcode = this.sortInfo.getBarcode();
            if (barcode == null || barcode.equals("")) {
                barcode = "none";
            }
            dbOperator.setString(1, barcode);
            String slots = daJsonObject.getString("slotsContent");
            if (slots == null || slots.equals("")) {
                slots = "none";
            }
            dbOperator.setString(2, slots);
            String platId = String.valueOf(this.sortInfo.getPlatId());
            if (platId == null || platId.equals("")) {
                platId = "none";
            }
            dbOperator.setString(3, platId);
            String carId = this.sortInfo.getCarId();
            if (carId == null || carId.equals("")) {
                carId = "none";
            }
            dbOperator.setString(4, carId);
            String videoResult = this.sortInfo.getComplementResult();
            if (videoResult == null || videoResult.equals("")) {
                videoResult = "none";
            }
            dbOperator.setString(5, videoResult);
            String videoFlag = daJsonObject.getString("cpFlag");
            if (videoFlag == null || videoFlag.equals("")) {
                videoFlag = "none";
            }
            dbOperator.setString(6, videoFlag);
            int res = dbOperator.executeUpdate();
            ret = res <= 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

