/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.sto;

import com.simba.common.command.ICommand;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.controllers.sto.STOCommonParams;
import java.io.Closeable;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class WebSynTime
implements ICommand {
    public static final String NAME = "WebSynTime";
    private static final Logger logger = Logger.getLogger(WebSynTime.class);

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        String urlPostFix = "/iot/sync-time";
        String serverHost = STOCommonParams.getInstance().getRemoteStoServer();
        String serverPort = STOCommonParams.getInstance().getRemotePort();
        String url = "http://" + serverHost + ":" + serverPort + urlPostFix;
        HttpPost postRequest = new HttpPost(url);
        String content = this.createQueryMsg();
        StringEntity contentEntity = new StringEntity(content, "UTF-8");
        contentEntity.setContentEncoding("UTF-8");
        contentEntity.setContentType("application/json");
        postRequest.setEntity(contentEntity);
        Closeable response = null;
        String strResSlots = "";
        boolean resType = false;
        try {
            SimpleDateFormat dfs = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            long between = 0L;
            Date day = new Date();
            String begin = dfs.format(System.currentTimeMillis());
            Date begins = dfs.parse(begin);
            LogUtil.LogDebug(logger, "[WebSynTime] Query Content:" + content);
            response = WebCommandExecutor.getInstance().doHttpServiceByPost(postRequest);
            HttpEntity entity = response.getEntity();
            byte[] contentBuffer = EntityUtils.toByteArray(entity);
            content = new String(contentBuffer, "UTF-8");
            LogUtil.LogDebug(logger, "[WebSynTime] response Content:" + content);
            String end = dfs.format(System.currentTimeMillis());
            Date ends = dfs.parse(end);
            between = ends.getTime() - begins.getTime();
            if (between > 200L) {
                LogUtil.LogDebug(logger, "[WebSynTime] cost too much time:" + between);
            }
            JSONObject responseObj = new JSONObject(content);
            boolean respCode = responseObj.getBoolean("success");
            JSONObject dataObj = responseObj.getJSONObject("data");
            long serverTime = 0L;
            if (dataObj.has("serverTime")) {
                serverTime = dataObj.getLong("serverTime");
            }
            LogUtil.LogDebug(logger, "[WebSynTime] response serverTime=" + serverTime);
            if (!respCode) {
                this.printFailed(responseObj);
                ret = false;
            } else {
                this.printSuccess(responseObj);
                ret = true;
            }
        }
        catch (IOException ex) {
            LogUtil.LogError(logger, "[WebSynTime] Catch IO Exception: Request Content:[" + content + "] Exception Message:" + ex.getMessage());
            ret = false;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException ex) {
                    LogUtil.LogError(logger, "[WebSynTime] Catch an exception when close a http response :" + ex.getMessage());
                }
            }
        }
        return ret;
    }

    private void printFailed(JSONObject responseObj) {
        try {
            StringBuilder info = new StringBuilder("[query setting info Failed!] :");
            String respCode = responseObj.getString("errorCode");
            String resMessage = responseObj.getString("errorMsg");
            if (respCode == null) {
                respCode = "";
            }
            if (resMessage == null) {
                resMessage = "";
            }
            info.append(" errorCode:" + respCode);
            info.append(" errorMsg:" + resMessage);
            LogUtil.LogDebug(logger, info.toString());
        }
        catch (Exception e) {
            LogUtil.LogDebug(logger, "[WebSynTime.printFailed] Catch an exception" + e.toString());
        }
    }

    private void printSuccess(JSONObject responseObj) {
        try {
            StringBuilder info = new StringBuilder("[request SynTime Success!]");
            LogUtil.LogDebug(logger, info.toString());
        }
        catch (Exception e) {
            LogUtil.LogDebug(logger, "[WebSynTime.printSuccess] Catch an exception" + e.toString());
        }
    }

    public String createQueryMsg() {
        JSONObject requestObj = new JSONObject();
        try {
            requestObj.put("productId", STOCommonParams.getInstance().getProductID());
            requestObj.put("deviceId", STOCommonParams.getInstance().getDeviceID());
            requestObj.put("timestamp", System.currentTimeMillis());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return requestObj.toString();
    }
}

