/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.sto;

import com.simba.common.command.ICommand;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.LogUtil;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.sto.STOCommonParams;
import java.io.Closeable;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebSortPlanCmd
implements ICommand {
    public static final String NAME = "WebSortPlanCmd";
    private static final Logger logger = Logger.getLogger(WebSortPlanCmd.class);
    private final SortInfo sortInfo;

    public WebSortPlanCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        String urlPostFix = "/iot/query-chute";
        String serverHost = STOCommonParams.getInstance().getRemoteStoServer();
        String serverPort = STOCommonParams.getInstance().getRemotePort();
        String url = "http://" + serverHost + ":" + serverPort + urlPostFix;
        HttpPost postRequest = new HttpPost(url);
        String content = this.createQuerySlotMsg();
        StringEntity contentEntity = new StringEntity(content, "UTF-8");
        contentEntity.setContentEncoding("UTF-8");
        contentEntity.setContentType("application/json");
        postRequest.setEntity(contentEntity);
        Closeable response = null;
        String strResSlots = "";
        int resType = 0;
        try {
            JSONArray slots;
            SimpleDateFormat dfs = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            long between = 0L;
            Date day = new Date();
            String begin = dfs.format(System.currentTimeMillis());
            Date begins = dfs.parse(begin);
            LogUtil.LogDebug(logger, "[WebSortPlanCmd] Query Content:" + content);
            response = WebCommandExecutor.getInstance().doHttpServiceByPost(postRequest);
            HttpEntity entity = response.getEntity();
            byte[] contentBuffer = EntityUtils.toByteArray(entity);
            content = new String(contentBuffer, "UTF-8");
            LogUtil.LogDebug(logger, "[WebSortPlanCmd] response Content:" + content);
            String end = dfs.format(System.currentTimeMillis());
            Date ends = dfs.parse(end);
            between = ends.getTime() - begins.getTime();
            if (between > 200L) {
                LogUtil.LogDebug(logger, "[WebSortPlanCmd] cost too much time:" + between);
            }
            JSONObject responseObj = new JSONObject(content);
            boolean respCode = responseObj.getBoolean("success");
            JSONObject dataObj = responseObj.getJSONObject("data");
            if (dataObj.has("chuteCode") && (slots = dataObj.getJSONArray("chuteCode")) != null && slots.length() > 0) {
                for (int i = 0; i < slots.length(); ++i) {
                    strResSlots = strResSlots + slots.getInt(i) + ",";
                    this.sortInfo.getSlotsList().add(slots.getInt(i));
                }
            }
            if (dataObj.has("type")) {
                resType = dataObj.getInt("type");
                this.sortInfo.setServerErrorCode(resType);
                if (resType >= 3) {
                    this.sortInfo.setInterceptFlag(1);
                    this.sortInfo.setRookieServerError(3);
                }
            }
            if (!respCode) {
                this.printRequestSlotFailed(responseObj);
                ret = false;
            } else {
                this.printRequestSlotSuccess(responseObj);
                ret = true;
            }
            LogUtil.LogDebug(logger, "barcode=" + this.sortInfo.getBarcode() + " slots=" + strResSlots + " type=" + resType);
        }
        catch (IOException ex) {
            LogUtil.LogError(logger, "[WebSortPlanCmd] Catch IO Exception: Request Content:[" + content + "] Exception Message:" + ex.getMessage());
            ret = false;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException ex) {
                    LogUtil.LogError(logger, "[WebSortPlanCmd] Catch an exception when close a http response :" + ex.getMessage());
                }
            }
        }
        return ret;
    }

    private void printRequestSlotFailed(JSONObject responseObj) {
        try {
            StringBuilder info = new StringBuilder("[upload sortplan info Failed!] :");
            String respCode = responseObj.getString("errorCode");
            String resMessage = responseObj.getString("errorMsg");
            if (respCode == null) {
                respCode = "";
            }
            if (resMessage == null) {
                resMessage = "";
            }
            info.append(" errorCode:" + respCode);
            info.append(" errorMsg:" + resMessage);
            LogUtil.LogDebug(logger, info.toString());
        }
        catch (Exception e) {
            LogUtil.LogDebug(logger, "[WebSortPlanCmd.printRequestSlotFailed] Catch an exception" + e.toString());
        }
    }

    private void printRequestSlotSuccess(JSONObject responseObj) {
        try {
            StringBuilder info = new StringBuilder("[request slot Success!]");
            LogUtil.LogDebug(logger, info.toString());
        }
        catch (Exception e) {
            LogUtil.LogDebug(logger, "[WebSortPlanCmd.printRequestSlotSuccess] Catch an exception" + e.toString());
        }
    }

    public String createQuerySlotMsg() {
        JSONObject requestObj = new JSONObject();
        if (this.sortInfo == null) {
            return null;
        }
        try {
            requestObj.put("productId", STOCommonParams.getInstance().getProductID());
            requestObj.put("deviceId", STOCommonParams.getInstance().getDeviceID());
            requestObj.put("waybillNo", this.sortInfo.getBarcode());
            requestObj.put("scanTime", this.sortInfo.getTimestampScanned().getTime());
            int bizType = 2;
            if (SortControllerManager.getInstance().getCurrentSortType().equalsIgnoreCase("arrival")) {
                bizType = 1;
            }
            requestObj.put("bizType", bizType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return requestObj.toString();
    }
}

