/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.sto;

import com.simba.common.command.ICommand;
import com.simba.common.command.WebCommandExecutor;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.data.StaticInfo;
import com.simba.server.controllers.sto.STOCommonParams;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class STOStaticCmd
implements ICommand {
    private final StaticInfo staticInfo;
    private static final Logger logger = Logger.getLogger(STOStaticCmd.class);

    public STOStaticCmd(StaticInfo staticInfo) {
        this.staticInfo = staticInfo;
    }

    @Override
    public String getName() {
        return "STOStatic";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        String urlPostFix = "/api/DataSupplier";
        String url = "http://" + STOCommonParams.getInstance().getStoServerStaticHost();
        url = url + ":" + STOCommonParams.getInstance().getStoServerStaticPort() + urlPostFix;
        HttpPost postRequest = new HttpPost(url);
        String content = STOCommonParams.getInstance().createStoSortStatic(this.staticInfo);
        StringEntity contentEntity = new StringEntity(content, "UTF-8");
        contentEntity.setContentEncoding("UTF-8");
        contentEntity.setContentType("application/json");
        postRequest.setEntity(contentEntity);
        CloseableHttpResponse response = null;
        try {
            response = WebCommandExecutor.getInstance().doHttpServiceByPost(postRequest);
            HttpEntity entity = response.getEntity();
            byte[] contentBuffer = EntityUtils.toByteArray(entity);
            content = new String(contentBuffer, "UTF-8");
            JSONObject responseObj = new JSONObject(content);
            String status = "false";
            if (responseObj.has("Success")) {
                ret = responseObj.getBoolean("Success");
            } else {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Response Content:[" + content + "]" + this.staticInfo.getPlatID(), 2));
                ret = false;
            }
        }
        catch (IOException ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch IO Exception when request sort info , Request Content:[" + content + "] Exception Message:" + ex.getMessage(), 2));
            ret = false;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException ex) {
                    LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch an exception when close a http response :" + ex.getMessage(), 2));
                }
            }
        }
        return ret;
    }
}

