/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.sto;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.data.SortInfo;
import java.sql.ResultSet;
import org.apache.log4j.Logger;

public class STOSortResultHistoryCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(STOSortResultHistoryCmd.class);
    private final SortInfo sortInfo;

    public STOSortResultHistoryCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return "STOSortResultHistory";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        String sql = "select * from tt_sto_packet_off_history  where barcode=?";
        try {
            String wayBillNo = this.sortInfo.getBarcode();
            dbOperator.prepareStatement(sql);
            dbOperator.setString(1, wayBillNo);
            ResultSet rs = dbOperator.executeQuery();
            while (rs.next()) {
                int droppedSlot = rs.getInt("droppedSlot");
                this.sortInfo.setDroppedSlotId(droppedSlot);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when query tt_sto_packet_off_history info : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

