/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.sto;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.data.StoSortPlanMap;
import com.simba.server.controllers.sto.data.STOSlotManager;
import java.sql.ResultSet;
import java.util.concurrent.ConcurrentHashMap;

public class STOSortPlanDResetCmd
implements ICommand {
    private final String sql = "select * from tt_sto_plan_departure;";
    private final ConcurrentHashMap<String, String> stoSortPlanD;

    public STOSortPlanDResetCmd(StoSortPlanMap SortPlan) {
        this.stoSortPlanD = SortPlan.getSortPlanMap();
    }

    @Override
    public String getName() {
        return "STOSortPlanDReset";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            ResultSet rs = dbOperator.executeQuery();
            while (rs.next()) {
                String strFullKey = "";
                String SlotId = rs.getString("slotId");
                String strStoCode1 = rs.getString("Code1");
                strStoCode1 = STOSlotManager.getInstance().getUpperCase(strStoCode1);
                if (strStoCode1 != null && strStoCode1.trim().length() > 1) {
                    strFullKey = strStoCode1;
                }
                if (!this.stoSortPlanD.containsKey(strFullKey)) {
                    this.stoSortPlanD.put(strFullKey, SlotId);
                    continue;
                }
                String priorV = this.stoSortPlanD.get(strFullKey);
                String value = priorV + "," + SlotId;
                this.stoSortPlanD.put(strFullKey, value);
            }
            ret = true;
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

