/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.sto;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.data.SortInfo;
import com.simba.server.components.data.SortPlanItem;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class STOSortPlanDNewCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(STOSortPlanDNewCmd.class);
    private final SortInfo sortInfo;

    public STOSortPlanDNewCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return "STOSortPlanDNew";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            JSONObject dataObj = this.sortInfo.getDataObj();
            String Code1 = dataObj.getString("Code1");
            String Code2 = dataObj.getString("Code2");
            if (Code1 == null || Code1.equalsIgnoreCase("")) {
                Code1 = "";
                return ret;
            }
            if (Code2 == null || Code2.equalsIgnoreCase("")) {
                Code2 = "0";
            }
            boolean findSlot = false;
            DbOperator dbOperator = (DbOperator)params;
            findSlot = this.getSortPlan(Code1, Code2, dbOperator, this.sortInfo);
            if (!findSlot) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "can't find any sort plan code1=" + Code1, 2));
            }
            for (int i = 0; i < this.sortInfo.getSortPlanList().size(); ++i) {
                ret = true;
                SortPlanItem sortPlan = this.sortInfo.getSortPlanList().get(i);
                this.sortInfo.getSlotsList().add(sortPlan.getFactualSlot());
            }
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }

    private boolean getSortPlan(String Code1, String Code2, DbOperator dbOperator, SortInfo sortInfo) {
        boolean isFindPlan = false;
        String strSql = "SELECT * from tt_sto_plan_departure where Code1=?";
        try {
            dbOperator.prepareStatement(strSql);
            dbOperator.setString(1, Code1);
            ResultSet rs = dbOperator.executeQuery();
            LinkedList<SortPlanItem> fullKeyList = new LinkedList<SortPlanItem>();
            LinkedList<SortPlanItem> partKeyList = new LinkedList<SortPlanItem>();
            LinkedList<String> partKeySlotList = new LinkedList<String>();
            LinkedList<String> fullKeySlotList = new LinkedList<String>();
            while (rs.next()) {
                isFindPlan = true;
                SortPlanItem sortPlanItem = new SortPlanItem();
                int slot = rs.getInt("slotId");
                String packName = rs.getString("nextstaname");
                int slotPack = 1;
                String nextStaCode = rs.getString("nextstacode");
                String dbCode2 = "";
                try {
                    if (rs.findColumn("Code2") > 0 && ((dbCode2 = rs.getString("Code2")) == null || dbCode2.equalsIgnoreCase("") || dbCode2.equalsIgnoreCase("0"))) {
                        dbCode2 = "";
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                sortPlanItem.setFactualSlot(slot);
                sortPlanItem.setPackName(packName);
                sortPlanItem.setSlotPack(slotPack);
                sortPlanItem.setNextStaCode(nextStaCode);
                if (dbCode2.length() > 0 && dbCode2.equalsIgnoreCase(Code2)) {
                    if (fullKeyList.contains(sortPlanItem) || fullKeySlotList.contains(String.valueOf(slot))) continue;
                    fullKeySlotList.add(String.valueOf(slot));
                    fullKeyList.add(sortPlanItem);
                    continue;
                }
                if (!dbCode2.equalsIgnoreCase("") || partKeyList.contains(sortPlanItem) || partKeySlotList.contains(String.valueOf(slot))) continue;
                partKeySlotList.add(String.valueOf(slot));
                partKeyList.add(sortPlanItem);
            }
            if (fullKeyList.size() > 0) {
                for (int i = 0; i < fullKeyList.size(); ++i) {
                    sortInfo.getSortPlanList().add((SortPlanItem)fullKeyList.get(i));
                }
            } else if (partKeyList.size() > 0) {
                for (int i = 0; i < partKeyList.size(); ++i) {
                    sortInfo.getSortPlanList().add((SortPlanItem)partKeyList.get(i));
                }
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when query sort plan departure : " + ex.getMessage(), 2));
        }
        return isFindPlan;
    }
}

