/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.sto;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.data.StoSortPlanMap;
import com.simba.server.controllers.sto.data.STOSlotManager;
import java.sql.ResultSet;
import java.util.concurrent.ConcurrentHashMap;

public class STOSortPlanDInterceptResetCmd
implements ICommand {
    private final String sql = "select * from tt_sto_plan_departure_intercept;";
    private final ConcurrentHashMap<String, String> stoSortPlanDIntercept;

    public STOSortPlanDInterceptResetCmd(StoSortPlanMap SortPlan) {
        this.stoSortPlanDIntercept = SortPlan.getSortPlanMap();
    }

    @Override
    public String getName() {
        return "stoSortPlanDInterceptReset";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            ResultSet rs = dbOperator.executeQuery();
            while (rs.next()) {
                String strFullKey = "";
                String strStoCode1 = rs.getString("Code1");
                String strStoCode2 = rs.getString("Code2");
                String strInterSiteName = rs.getString("interceptSiteName");
                strStoCode1 = STOSlotManager.getInstance().getUpperCase(strStoCode1);
                strStoCode2 = STOSlotManager.getInstance().getUpperCase(strStoCode2);
                if (strStoCode1 == null || strStoCode1.trim().length() <= 1) continue;
                strFullKey = strStoCode1;
                if (strStoCode2 != null && strStoCode2.trim().length() > 1) {
                    strFullKey = strFullKey + "," + strStoCode2;
                }
                if (strInterSiteName == null || strInterSiteName.equalsIgnoreCase("")) {
                    strInterSiteName = "";
                }
                this.stoSortPlanDIntercept.put(strFullKey, strInterSiteName);
            }
            ret = true;
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

