/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.sto;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.sto.data.STOSlotManager;
import org.json.JSONObject;

public class STOSortPlanDInterceptCmd
implements ICommand {
    private final SortInfo sortInfo;

    public STOSortPlanDInterceptCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return "STOSortPlanDIntercept";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            JSONObject dataObj = this.sortInfo.getDataObj();
            String Code1 = dataObj.getString("Code1");
            Code1 = STOSlotManager.getInstance().getUpperCase(Code1);
            String Code2 = dataObj.getString("Code2");
            Code2 = STOSlotManager.getInstance().getUpperCase(Code2);
            String partKey = Code1;
            String fullKey = Code1 + "," + Code2;
            if (STOSlotManager.getInstance().getStoSortPlanD().size() == 0) {
                STOSlotManager.getInstance().resetStoSortPlan();
            }
            if (STOSlotManager.getInstance().getStoSortPlanDIntercept().containsKey(fullKey) || STOSlotManager.getInstance().getStoSortPlanDIntercept().containsKey(partKey)) {
                ret = true;
            }
            if (STOSlotManager.getInstance().getBarcodeIntercept().containsKey(this.sortInfo.getBarcode())) {
                ret = true;
            }
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

