/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.sto;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.data.StoSortPlanMap;
import com.simba.server.controllers.sto.data.STOSlotManager;
import java.sql.ResultSet;
import java.util.concurrent.ConcurrentHashMap;

public class STOSortPlanAResetCmd
implements ICommand {
    private final String sql = "select * from tt_sto_plan_arrival;";
    private final ConcurrentHashMap<String, String> stoSortPlanA;

    public STOSortPlanAResetCmd(StoSortPlanMap SortPlanMap) {
        this.stoSortPlanA = SortPlanMap.getSortPlanMap();
    }

    @Override
    public String getName() {
        return "STOSortPlanAReset";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            ResultSet rs = dbOperator.executeQuery();
            while (rs.next()) {
                String strFullKey = "";
                String SlotId = rs.getString("slotId");
                String strStoCode1 = rs.getString("Code1");
                String strStoCode2 = rs.getString("Code2");
                String strStoCode3 = rs.getString("Code3");
                strStoCode2 = STOSlotManager.getInstance().getUpperCase(strStoCode2);
                strStoCode3 = STOSlotManager.getInstance().getUpperCase(strStoCode3);
                if (strStoCode1 != null && strStoCode1.trim().length() >= 1) {
                    strFullKey = strStoCode1 + ",";
                }
                if (strStoCode2 != null && strStoCode2.trim().length() > 1) {
                    strFullKey = strFullKey + strStoCode2 + ",";
                }
                if (strStoCode3 != null && strStoCode3.trim().length() > 1) {
                    strFullKey = strFullKey + strStoCode3;
                }
                if (strFullKey.endsWith(",")) {
                    strFullKey = strFullKey.substring(0, strFullKey.length() - 1);
                }
                if (!this.stoSortPlanA.containsKey(strFullKey)) {
                    this.stoSortPlanA.put(strFullKey, SlotId);
                    continue;
                }
                String priorV = this.stoSortPlanA.get(strFullKey);
                String value = priorV + "," + SlotId;
                this.stoSortPlanA.put(strFullKey, value);
            }
            ret = true;
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

