/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.sto;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.data.SortInfo;
import com.simba.server.components.data.SortPlanItem;
import com.simba.server.controllers.sto.data.STOSlotManager;
import java.sql.ResultSet;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class STOSortPlanANewCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(STOSortPlanANewCmd.class);
    private final SortInfo sortInfo;

    public STOSortPlanANewCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return "STOSortPlanANew";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            JSONObject dataObj = this.sortInfo.getDataObj();
            String Code1 = dataObj.getString("Code1");
            String Code2 = dataObj.getString("Code2");
            String Code3 = dataObj.getString("Code3");
            if (Code1 == null || Code1.equalsIgnoreCase("")) {
                Code1 = "";
            }
            if (Code2 == null || Code2.equalsIgnoreCase("")) {
                Code2 = "";
            }
            if (Code3 == null || Code3.equalsIgnoreCase("")) {
                Code3 = "";
            }
            Code2 = STOSlotManager.getInstance().getUpperCase(Code2);
            Code3 = STOSlotManager.getInstance().getUpperCase(Code3);
            boolean findSlot = false;
            DbOperator dbOperator = (DbOperator)params;
            findSlot = this.getSortPlan(Code1, Code2, Code3, dbOperator, this.sortInfo);
            if (!findSlot && Code2.length() == 6) {
                StringBuilder sb = new StringBuilder(Code2);
                sb.insert(3, "*");
                Code2 = sb.toString();
                findSlot = this.getSortPlan(Code1, Code2, Code3, dbOperator, this.sortInfo);
            }
            if (!findSlot) {
                findSlot = this.getSortPlanByCode1(Code1, dbOperator, this.sortInfo);
            }
            if (!findSlot) {
                LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "can't find any sort plan code1=" + Code1 + ",Code2=" + Code2 + ",Code3=" + Code3, 2));
            }
            for (int i = 0; i < this.sortInfo.getSortPlanList().size(); ++i) {
                ret = true;
                SortPlanItem sortPlan = this.sortInfo.getSortPlanList().get(i);
                this.sortInfo.getSlotsList().add(sortPlan.getFactualSlot());
            }
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }

    private boolean getSortPlan(String Code1, String Code2, String Code3, DbOperator dbOperator, SortInfo sortInfo) {
        boolean isFindPlan = false;
        String strSql = "SELECT * from tt_sto_plan_arrival where Code1=? and Code2=?";
        try {
            dbOperator.prepareStatement(strSql);
            dbOperator.setString(1, Code1);
            dbOperator.setString(2, Code2);
            ResultSet rs = dbOperator.executeQuery();
            LinkedList<SortPlanItem> fullKeyList = new LinkedList<SortPlanItem>();
            LinkedList<SortPlanItem> partKeyList = new LinkedList<SortPlanItem>();
            LinkedList<String> fullKeySlotList = new LinkedList<String>();
            LinkedList<String> partKeySlotList = new LinkedList<String>();
            while (rs.next()) {
                isFindPlan = true;
                SortPlanItem sortPlanItem = new SortPlanItem();
                int slot = rs.getInt("slotId");
                String packName = rs.getString("orgName");
                int slotPack = rs.getInt("isSlotPack");
                String dbCode3 = rs.getString("Code3");
                if (dbCode3 == null || dbCode3.equalsIgnoreCase("") || dbCode3.equalsIgnoreCase("0")) {
                    dbCode3 = "";
                }
                String nextStaCode = rs.getString("nextStacode");
                sortPlanItem.setFactualSlot(slot);
                sortPlanItem.setPackName(packName);
                sortPlanItem.setSlotPack(slotPack);
                sortPlanItem.setNextStaCode(nextStaCode);
                if (dbCode3.length() > 0 && dbCode3.equalsIgnoreCase(Code3)) {
                    if (fullKeyList.contains(sortPlanItem) || fullKeySlotList.contains(String.valueOf(slot))) continue;
                    fullKeySlotList.add(String.valueOf(slot));
                    fullKeyList.add(sortPlanItem);
                    continue;
                }
                if (!dbCode3.equalsIgnoreCase("") || partKeyList.contains(sortPlanItem) || partKeySlotList.contains(String.valueOf(slot))) continue;
                partKeySlotList.add(String.valueOf(slot));
                partKeyList.add(sortPlanItem);
            }
            if (fullKeyList.size() > 0) {
                for (int i = 0; i < fullKeyList.size(); ++i) {
                    sortInfo.getSortPlanList().add((SortPlanItem)fullKeyList.get(i));
                }
            } else if (partKeyList.size() > 0) {
                for (int i = 0; i < partKeyList.size(); ++i) {
                    sortInfo.getSortPlanList().add((SortPlanItem)partKeyList.get(i));
                }
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when query sort plan arrival : " + ex.getMessage(), 2));
        }
        return isFindPlan;
    }

    private boolean getSortPlanByCode1(String Code1, DbOperator dbOperator, SortInfo sortInfo) {
        boolean isFindPlan = false;
        String strSql = "SELECT * from tt_sto_plan_arrival where Code1=?  and LENGTH(Code2)<=1";
        try {
            dbOperator.prepareStatement(strSql);
            dbOperator.setString(1, Code1);
            ResultSet rs = dbOperator.executeQuery();
            LinkedList<SortPlanItem> fullKeyList = new LinkedList<SortPlanItem>();
            LinkedList<String> fullKeySlotList = new LinkedList<String>();
            while (rs.next()) {
                isFindPlan = true;
                SortPlanItem sortPlanItem = new SortPlanItem();
                int slot = rs.getInt("slotId");
                String packName = rs.getString("orgName");
                int slotPack = rs.getInt("isSlotPack");
                String nextStaCode = rs.getString("nextStacode");
                sortPlanItem.setFactualSlot(slot);
                sortPlanItem.setPackName(packName);
                sortPlanItem.setSlotPack(slotPack);
                sortPlanItem.setNextStaCode(nextStaCode);
                if (fullKeyList.contains(sortPlanItem) || fullKeySlotList.contains(String.valueOf(slot))) continue;
                fullKeySlotList.add(String.valueOf(slot));
                fullKeyList.add(sortPlanItem);
            }
            if (fullKeyList.size() > 0) {
                for (int i = 0; i < fullKeyList.size(); ++i) {
                    sortInfo.getSortPlanList().add((SortPlanItem)fullKeyList.get(i));
                }
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when query sort plan arrival getSortPlanByCode1 : " + ex.getMessage(), 2));
        }
        return isFindPlan;
    }
}

