/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.sto;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.sto.data.STOSlotManager;
import org.json.JSONObject;

public class STOSortPlanACmd
implements ICommand {
    private final SortInfo sortInfo;

    public STOSortPlanACmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return "STOSortPlanA";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            JSONObject dataObj = this.sortInfo.getDataObj();
            String Code1 = dataObj.getString("Code1");
            String Code2 = dataObj.getString("Code2");
            String Code3 = dataObj.getString("Code3");
            if (Code1 == null || Code1.equalsIgnoreCase("")) {
                Code1 = "";
            }
            if (Code2 == null || Code2.equalsIgnoreCase("")) {
                Code2 = "";
            }
            if (Code3 == null || Code3.equalsIgnoreCase("")) {
                Code3 = "";
            }
            Code2 = STOSlotManager.getInstance().getUpperCase(Code2);
            Code3 = STOSlotManager.getInstance().getUpperCase(Code3);
            String fullKey = Code1 + "," + Code2 + "," + Code3;
            String partKey = Code1 + "," + Code2;
            String strSlots = "";
            if (fullKey.endsWith(",")) {
                fullKey = fullKey.substring(0, fullKey.length() - 1);
            }
            if (partKey.endsWith(",")) {
                partKey = partKey.substring(0, partKey.length() - 1);
            }
            if (STOSlotManager.getInstance().getStoSortPlanA().size() == 0) {
                STOSlotManager.getInstance().resetStoSortPlan();
            }
            boolean findSlot = false;
            if (STOSlotManager.getInstance().getStoSortPlanA().containsKey(fullKey)) {
                findSlot = true;
                strSlots = STOSlotManager.getInstance().getStoSortPlanA().get(fullKey);
            } else if (STOSlotManager.getInstance().getStoSortPlanA().containsKey(partKey)) {
                findSlot = true;
                strSlots = STOSlotManager.getInstance().getStoSortPlanA().get(partKey);
            }
            if (!findSlot && Code2.length() == 6) {
                StringBuilder sb = new StringBuilder(Code2);
                sb.insert(3, "*");
                Code2 = sb.toString();
                fullKey = Code1 + "," + Code2 + "," + Code3;
                partKey = Code1 + "," + Code2;
                if (fullKey.endsWith(",")) {
                    fullKey = fullKey.substring(0, fullKey.length() - 1);
                }
                if (partKey.endsWith(",")) {
                    partKey = partKey.substring(0, partKey.length() - 1);
                }
                if (STOSlotManager.getInstance().getStoSortPlanA().containsKey(fullKey)) {
                    findSlot = true;
                    strSlots = STOSlotManager.getInstance().getStoSortPlanA().get(fullKey);
                } else if (STOSlotManager.getInstance().getStoSortPlanA().containsKey(partKey)) {
                    findSlot = true;
                    strSlots = STOSlotManager.getInstance().getStoSortPlanA().get(partKey);
                }
            }
            if (!strSlots.equalsIgnoreCase("")) {
                String[] arrSlots = strSlots.split(",");
                for (int i = 0; i < arrSlots.length; ++i) {
                    ret = true;
                    String strSlot = arrSlots[i];
                    this.sortInfo.getSlotsList().add(Integer.parseInt(strSlot));
                }
            }
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

