/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.sto;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.SortInfoManager;
import com.simba.server.components.data.SortInfo;
import java.sql.ResultSet;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class STOSortInfoDCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(STOSortInfoDCmd.class);
    private final SortInfo sortInfo;

    public STOSortInfoDCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return "STOSortInfoD";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        String sql = "select * from tt_sto_order_recevie  where WAYBILLNO=?  ORDER BY SysRecevieTime ASC";
        try {
            String wayBillNo = this.sortInfo.getBarcode();
            dbOperator.prepareStatement(sql);
            dbOperator.setString(1, wayBillNo);
            ResultSet rs = dbOperator.executeQuery();
            String Code1 = "";
            String Code2 = "";
            String Code3 = "";
            boolean isFindBarCode = false;
            int isInterceptor = 0;
            while (rs.next()) {
                int sortInfoPriority;
                String orderType;
                String DbCode3;
                String DbCode1 = rs.getString("Code1");
                if (DbCode1 == null || DbCode1.equalsIgnoreCase("NULL") || DbCode1.equalsIgnoreCase("null") || DbCode1.equalsIgnoreCase(null)) {
                    DbCode1 = "";
                    continue;
                }
                String DbCode2 = rs.getString("Code2");
                if (DbCode2 == null || DbCode2.equalsIgnoreCase(null) || DbCode2.equalsIgnoreCase("NULL") || DbCode2.equalsIgnoreCase("null")) {
                    DbCode2 = "";
                }
                if ((DbCode3 = rs.getString("Code3")) == null || DbCode3.equalsIgnoreCase(null) || DbCode3.equalsIgnoreCase("NULL") || DbCode3.equalsIgnoreCase("null")) {
                    DbCode3 = "";
                }
                if ((orderType = rs.getString("OrderTypeEx")) != null && orderType.equalsIgnoreCase("Interceptor")) {
                    isInterceptor = 1;
                }
                int priority = 0;
                if (orderType == null) continue;
                isFindBarCode = true;
                priority = SortInfoManager.getInstance().getWaybillPriority(orderType);
                if (priority < (sortInfoPriority = this.sortInfo.getPriority())) continue;
                this.sortInfo.setPriority(priority);
                isFindBarCode = true;
                if (DbCode1.length() <= 0) continue;
                Code1 = DbCode1;
                Code2 = DbCode2;
                Code3 = DbCode3;
            }
            this.sortInfo.setInterceptFlag(isInterceptor);
            JSONObject jsobj = this.sortInfo.getDataObj();
            if (Code1.contains("*")) {
                Code1 = Code1.substring(0, Code1.indexOf("*"));
            }
            jsobj.put("Code1", Code1);
            jsobj.put("Code2", Code2);
            jsobj.put("Code3", Code3);
            if (isFindBarCode) {
                ret = true;
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when query sort info : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

