/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.sto;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.SortInfoManager;
import com.simba.server.components.data.SortInfo;
import java.sql.ResultSet;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class STOSortInfoACmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(STOSortInfoACmd.class);
    private final SortInfo sortInfo;

    public STOSortInfoACmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return "STOSortInfoA";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        String sql = "select * from tt_sto_order_recevie  where WAYBILLNO=? AND LENGTH(Code2)>1  ORDER BY SysRecevieTime ASC";
        try {
            String wayBillNo = this.sortInfo.getBarcode();
            dbOperator.prepareStatement(sql);
            dbOperator.setString(1, wayBillNo);
            ResultSet rs = dbOperator.executeQuery();
            String Code1 = "";
            String Code2 = "";
            String Code3 = "";
            boolean isFindBarCode = false;
            String Rookie_Code1 = "";
            String Rookie_Code2 = "";
            String Rookie_Code3 = "";
            int isInterceptor = 0;
            while (rs.next()) {
                int sortInfoPriority;
                String DbCode1 = rs.getString("Code1");
                String DbCode2 = rs.getString("Code2");
                String DbCode3 = rs.getString("Code3");
                if (DbCode2 == null || Code2.equalsIgnoreCase("NULL") || Code2.equalsIgnoreCase("null") || Code2.equalsIgnoreCase(null)) {
                    DbCode2 = "";
                }
                if (DbCode2.equalsIgnoreCase("")) continue;
                String orderType = rs.getString("OrderTypeEx");
                if (orderType != null && orderType.equalsIgnoreCase("Interceptor")) {
                    isInterceptor = 1;
                }
                int priority = 0;
                if (orderType == null || (priority = SortInfoManager.getInstance().getWaybillPriority(orderType)) < (sortInfoPriority = this.sortInfo.getPriority())) continue;
                this.sortInfo.setPriority(priority);
                isFindBarCode = true;
                if (DbCode2.length() <= 0) continue;
                Code1 = DbCode1;
                Code2 = DbCode2;
                Code3 = DbCode3;
            }
            JSONObject jsobj = this.sortInfo.getDataObj();
            this.sortInfo.setInterceptFlag(isInterceptor);
            jsobj.put("Code1", Code1);
            jsobj.put("Code2", Code2);
            jsobj.put("Code3", Code3);
            if (isFindBarCode) {
                ret = true;
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when query sort info : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

