/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.sto;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.SortInfo;
import java.sql.Timestamp;
import org.json.JSONObject;

public class STOScannedCmd
implements ICommand {
    private final SortInfo sortInfo;
    private final String sql = "insert into tt_sto_scanned_info(platId,barcode,Code1,Code2,Code3,Slot,ErrorCode,sortInfoMode,scannedTime,layer) values(?,?,?,?,?,?,?,?,?,?);";

    public STOScannedCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return "STOScanned";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            String platId = String.valueOf(this.sortInfo.getPlcPlatID());
            if (platId == null || platId.equals("")) {
                platId = "none";
            }
            dbOperator.setString(1, platId);
            String barcode = this.sortInfo.getBarcode();
            if (barcode == null || barcode.equals("")) {
                barcode = "none";
            }
            dbOperator.setString(2, barcode);
            JSONObject dataObj = this.sortInfo.getDataObj();
            String stoMode = "none";
            if (dataObj.has("stoMode")) {
                stoMode = dataObj.getString("stoMode");
            }
            String code1 = "";
            if (dataObj.has("Code1")) {
                code1 = dataObj.getString("Code1");
            }
            dbOperator.setString(3, code1);
            String code2 = "";
            if (dataObj.has("Code2")) {
                code2 = dataObj.getString("Code2");
            }
            dbOperator.setString(4, code2);
            String code3 = "";
            if (dataObj.has("Code3")) {
                code3 = dataObj.getString("Code3");
            }
            dbOperator.setString(5, code3);
            int slot = this.sortInfo.getDroppedSlotId();
            dbOperator.setInt(6, slot);
            int errorCode = this.sortInfo.getServerErrorCode();
            dbOperator.setInt(7, errorCode);
            dbOperator.setString(8, stoMode);
            Timestamp scannedTime = this.sortInfo.getTimestampScanned();
            if (scannedTime == null) {
                scannedTime = SorterProtocolCreator.getInstance().createCurrentTimeStamp();
            }
            String scannedTimeContent = scannedTime.toString();
            dbOperator.setString(9, scannedTimeContent);
            dbOperator.setInt(10, this.sortInfo.getLayer());
            int res = dbOperator.executeUpdate();
            ret = res <= 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

