/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.sto;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.SortInfoManager;
import com.simba.server.components.data.SortInfo;
import java.sql.ResultSet;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class STORemoteSortInfoACmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(STORemoteSortInfoACmd.class);
    private final SortInfo sortInfo;

    public STORemoteSortInfoACmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return "STORemoteSortInfoA";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        DbOperator dbOperator = (DbOperator)params;
        String sql = "select * from orderrecevie  where WAYBILLNO=?  ORDER BY SysRecevieTime ASC";
        try {
            String wayBillNo = this.sortInfo.getBarcode();
            dbOperator.prepareStatement(sql);
            dbOperator.setString(1, wayBillNo);
            ResultSet rs = dbOperator.executeQuery();
            String Code1 = "";
            String Code2 = "";
            String Code3 = "";
            boolean isFindBarCode = false;
            String Rookie_Code1 = "";
            String Rookie_Code2 = "";
            String Rookie_Code3 = "";
            int isInterceptor = 0;
            while (rs.next()) {
                int sortInfoPriority;
                String orderType;
                String DbCode1 = rs.getString("Code1");
                String DbCode2 = rs.getString("Code2");
                String DbCode3 = rs.getString("Code3");
                if (DbCode2 == null || Code2.equalsIgnoreCase("NULL") || Code2.equalsIgnoreCase("null") || Code2.equalsIgnoreCase(null)) {
                    DbCode2 = "";
                }
                if ((orderType = rs.getString("OrderTypeEx")) != null && orderType.equalsIgnoreCase("Interceptor")) {
                    this.sortInfo.setRookieServerError(3);
                    isInterceptor = 1;
                }
                int priority = 0;
                if (orderType == null) continue;
                priority = SortInfoManager.getInstance().getWaybillPriority(orderType);
                if (priority >= (sortInfoPriority = this.sortInfo.getPriority())) {
                    this.sortInfo.setPriority(priority);
                    isFindBarCode = true;
                    if (DbCode2.length() > 0) {
                        Code1 = DbCode1;
                        Code2 = DbCode2;
                        Code3 = DbCode3;
                    }
                }
                if (isInterceptor != 1) continue;
                Code1 = DbCode1;
                Code2 = DbCode2;
                Code3 = DbCode3;
                break;
            }
            JSONObject jsobj = this.sortInfo.getDataObj();
            this.sortInfo.setInterceptFlag(isInterceptor);
            jsobj.put("Code1", Code1);
            jsobj.put("Code2", Code2);
            jsobj.put("Code3", Code3);
            if (isFindBarCode) {
                ret = true;
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when query sort info : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

